/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtree.backend.GuidedDecisionTreeDRLPersistence;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.type.FileNameUtil;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class GuidedDecisionTreeEditorCopyHelper
implements CopyHelper {
    @Inject
    private GuidedDTreeResourceTypeDefinition resourceType;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;

    public boolean supports(org.uberfire.backend.vfs.Path destination) {
        return this.resourceType.accept(destination);
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        Path _destination = Paths.convert((org.uberfire.backend.vfs.Path)destination);
        String drl = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)destination));
        String baseFileName = FileNameUtil.removeExtension((org.uberfire.backend.vfs.Path)source, (ResourceTypeDefinition)this.resourceType);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(source);
        GuidedDecisionTree model = GuidedDecisionTreeDRLPersistence.getInstance().unmarshal(drl, baseFileName, oracle);
        String treeName = FileNameUtil.removeExtension((org.uberfire.backend.vfs.Path)destination, (ResourceTypeDefinition)this.resourceType);
        model.setTreeName(treeName);
        this.ioService.write(_destination, GuidedDecisionTreeDRLPersistence.getInstance().marshal(model), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("File [" + source.toURI() + "] copied to [" + destination.toURI() + "].")});
    }
}

