/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.DirtyableVerticalPane;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class CompositeFactPatternWidget
extends RuleModellerWidget {
    protected final AsyncPackageDataModelOracle oracle;
    protected FlexTable layout;
    protected CompositeFactPattern pattern;
    protected boolean readOnly;
    protected boolean isFactTypeKnown;

    public CompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, CompositeFactPattern pattern, Boolean readOnly) {
        super(modeller, eventBus);
        this.oracle = modeller.getDataModelOracle();
        this.pattern = pattern;
        this.layout = new FlexTable();
        if (readOnly != null) {
            this.readOnly = readOnly;
            this.isFactTypeKnown = true;
        } else {
            this.readOnly = false;
            this.isFactTypeKnown = true;
            if (this.pattern != null && this.pattern.getPatterns() != null) {
                IFactPattern[] patterns = this.pattern.getPatterns();
                for (int i = 0; i < patterns.length; ++i) {
                    IFactPattern p = patterns[i];
                    if (p.getFactType() == null || this.oracle.isFactTypeRecognized(p.getFactType())) continue;
                    this.readOnly = true;
                    this.isFactTypeKnown = false;
                    break;
                }
            }
        }
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    private HTML spacerWidget() {
        HTML h = new HTML("&nbsp;");
        h.setHeight("2px");
        return h;
    }

    private Widget wrapLHSWidget(CompositeFactPattern model, int i, RuleModellerWidget w) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        remove.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisENTIREConditionAndAllTheFieldConstraintsThatBelongToIt());
        final int idx = i;
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisEntireConditionQ()) && CompositeFactPatternWidget.this.pattern.removeFactPattern(idx)) {
                    CompositeFactPatternWidget.this.getModeller().refreshWidget();
                }
            }
        });
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add((Widget)w);
        if (!this.getModeller().lockLHS() && !w.isReadOnly()) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    protected void doLayout() {
        this.layout.setWidget(0, 0, this.getCompositeLabel());
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (this.pattern.getPatterns() != null) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            IFactPattern[] facts = this.pattern.getPatterns();
            for (int i = 0; i < facts.length; ++i) {
                RuleModellerWidget widget = this.getModeller().getWidgetFactory().getWidget(this.getModeller(), this.getEventBus(), (IPattern)facts[i], (Boolean)this.readOnly);
                widget.addOnModifiedCommand(new Command(){

                    public void execute() {
                        CompositeFactPatternWidget.this.setModified(true);
                    }
                });
                vert.add(this.wrapLHSWidget(this.pattern, i, widget));
                vert.add((Widget)this.spacerWidget());
            }
            this.layout.setWidget(1, 1, (Widget)vert);
        }
    }

    protected Widget getCompositeLabel() {
        ClickHandler click = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                CompositeFactPatternWidget.this.showFactTypeSelector(w);
            }
        };
        String lbl = HumanReadable.getCEDisplayName((String)this.pattern.getType());
        if (this.pattern.getPatterns() == null || this.pattern.getPatterns().length == 0) {
            lbl = lbl + " <font color='red'>" + GuidedRuleEditorResources.CONSTANTS.clickToAddPatterns() + "</font>";
        }
        return new ClickableLabel(lbl + ":", click, !this.readOnly);
    }

    protected void showFactTypeSelector(Widget w) {
        final ListBox box = new ListBox();
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        String[] facts = oracle.getFactTypes();
        box.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.NewFactPattern());
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.chooseFactType(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CompositeFactPatternWidget.this.pattern.addFactPattern((IFactPattern)new FactPattern(box.getItemText(box.getSelectedIndex())));
                CompositeFactPatternWidget.this.setModified(true);
                CompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        final Button fromBtn = new Button(HumanReadableConstants.INSTANCE.From());
        final Button fromAccumulateBtn = new Button(HumanReadableConstants.INSTANCE.FromAccumulate());
        final Button fromCollectBtn = new Button(HumanReadableConstants.INSTANCE.FromCollect());
        ClickHandler btnsClickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget sender = (Widget)event.getSource();
                if (sender == fromBtn) {
                    CompositeFactPatternWidget.this.pattern.addFactPattern((IFactPattern)new FromCompositeFactPattern());
                } else if (sender == fromAccumulateBtn) {
                    CompositeFactPatternWidget.this.pattern.addFactPattern((IFactPattern)new FromAccumulateCompositeFactPattern());
                } else if (sender == fromCollectBtn) {
                    CompositeFactPatternWidget.this.pattern.addFactPattern((IFactPattern)new FromCollectCompositeFactPattern());
                } else {
                    throw new IllegalArgumentException("Unknown sender: " + sender);
                }
                CompositeFactPatternWidget.this.setModified(true);
                CompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        };
        fromBtn.addClickHandler(btnsClickHandler);
        fromAccumulateBtn.addClickHandler(btnsClickHandler);
        fromCollectBtn.addClickHandler(btnsClickHandler);
        popup.addAttribute("", (IsWidget)fromBtn);
        popup.addAttribute("", (IsWidget)fromAccumulateBtn);
        popup.addAttribute("", (IsWidget)fromCollectBtn);
        popup.show();
    }
}

