/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.ExpressionBuilder;
import org.drools.workbench.screens.guided.rule.client.widget.FactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class FromCompositeFactPatternWidget
extends RuleModellerWidget {
    protected FromCompositeFactPattern pattern;
    protected FlexTable layout;
    protected boolean readOnly;
    protected boolean isFactTypeKnown;

    public FromCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCompositeFactPattern pattern) {
        this(modeller, eventBus, pattern, null);
    }

    public FromCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCompositeFactPattern pattern, Boolean readOnly) {
        super(modeller, eventBus);
        this.pattern = pattern;
        if (readOnly == null) {
            this.calculateReadOnly();
        } else {
            this.readOnly = readOnly;
            this.isFactTypeKnown = true;
        }
        this.layout = new FlexTable();
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    protected void doLayout() {
        FactPattern fact;
        int row = 0;
        if (this.pattern.getFactPattern() != null && (fact = this.pattern.getFactPattern()) != null) {
            this.layout.setWidget(row++, 0, this.createFactPatternWidget(fact));
        }
        this.layout.setWidget(row++, 0, this.getCompositeLabel());
    }

    private Widget createFactPatternWidget(FactPattern fact) {
        if (this.readOnly) {
            FactPatternWidget factPatternWidget = new FactPatternWidget(this.getModeller(), this.getEventBus(), (IPattern)fact, false, true);
            return factPatternWidget;
        }
        FactPatternWidget factPatternWidget = new FactPatternWidget(this.getModeller(), this.getEventBus(), (IPattern)fact, true, false);
        factPatternWidget.addOnModifiedCommand(new Command(){

            public void execute() {
                FromCompositeFactPatternWidget.this.setModified(true);
            }
        });
        return this.addRemoveButton((Widget)factPatternWidget, this.createClickHandlerForAddRemoveButton());
    }

    private ClickHandler createClickHandlerForAddRemoveButton() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisEntireConditionQ())) {
                    FromCompositeFactPatternWidget.this.setModified(true);
                    FromCompositeFactPatternWidget.this.pattern.setFactPattern(null);
                    FromCompositeFactPatternWidget.this.getModeller().refreshWidget();
                }
            }
        };
    }

    protected Widget getCompositeLabel() {
        ClickHandler click = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                FromCompositeFactPatternWidget.this.showFactTypeSelector(w);
            }
        };
        String lbl = "<div class='form-field'>" + HumanReadable.getCEDisplayName((String)"from") + "&nbsp;</div>";
        FlexTable panel = new FlexTable();
        int r = 0;
        if (this.pattern.getFactPattern() == null) {
            panel.setWidget(r, 0, (Widget)new ClickableLabel("<br> <font color='red'>" + GuidedRuleEditorResources.CONSTANTS.clickToAddPatterns() + "</font>", click, !this.readOnly));
            ++r;
        }
        panel.setWidget(r, 0, (Widget)new HTML(lbl));
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getModeller(), this.getEventBus(), this.pattern.getExpression(), this.readOnly);
        expressionBuilder.addOnModifiedCommand(new Command(){

            public void execute() {
                FromCompositeFactPatternWidget.this.setModified(true);
            }
        });
        panel.setWidget(r, 1, (Widget)expressionBuilder);
        return panel;
    }

    protected void showFactTypeSelector(Widget w) {
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        final ListBox box = new ListBox();
        String[] facts = oracle.getFactTypes();
        box.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.NewFactPattern());
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.chooseFactType(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FromCompositeFactPatternWidget.this.pattern.setFactPattern(new FactPattern(box.getItemText(box.getSelectedIndex())));
                FromCompositeFactPatternWidget.this.setModified(true);
                FromCompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.show();
    }

    protected Widget addRemoveButton(Widget w, ClickHandler listener) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        remove.setAltText(GuidedRuleEditorResources.CONSTANTS.RemoveThisBlockOfData());
        remove.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisBlockOfData());
        remove.addClickHandler(listener);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add(w);
        if (!this.readOnly) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    protected void calculateReadOnly() {
        if (this.pattern.getFactPattern() != null) {
            this.isFactTypeKnown = this.getModeller().getDataModelOracle().isFactTypeRecognized(this.pattern.getFactPattern().getFactType());
            this.readOnly = !this.isFactTypeKnown;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }
}

