/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.handlers;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.type.GuidedRuleDRLResourceType;
import org.drools.workbench.screens.guided.rule.client.type.GuidedRuleDSLRResourceType;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewGuidedRuleHandler
extends DefaultNewResourceHandler {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<GuidedRuleEditorService> service;
    @Inject
    private GuidedRuleDRLResourceType resourceTypeDRL;
    @Inject
    private GuidedRuleDSLRResourceType resourceTypeDSLR;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    private CheckBox useDSLCheckbox = new CheckBox(GuidedRuleEditorResources.CONSTANTS.UseDSL());

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(new Pair((Object)GuidedRuleEditorResources.CONSTANTS.UseDSL(), (Object)this.useDSLCheckbox));
    }

    public String getDescription() {
        return GuidedRuleEditorResources.CONSTANTS.NewGuidedRuleDescription();
    }

    public IsWidget getIcon() {
        return new Image(GuidedRuleEditorResources.INSTANCE.images().typeGuidedRule());
    }

    public ResourceTypeDefinition getResourceType() {
        boolean useDSL = this.useDSLCheckbox.getValue();
        ClientResourceType resourceType = useDSL ? this.resourceTypeDSLR : this.resourceTypeDRL;
        return resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        RuleModel ruleModel = new RuleModel();
        boolean useDSL = this.useDSLCheckbox.getValue();
        ClientResourceType resourceType = useDSL ? this.resourceTypeDSLR : this.resourceTypeDRL;
        ruleModel.name = baseFileName;
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((GuidedRuleEditorService)this.service.call(this.getSuccessCallback(presenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)resourceType), (Object)ruleModel, "");
    }
}

