/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.screens.guided.rule.client.editor.AddConstraintButton;
import org.drools.workbench.screens.guided.rule.client.editor.BoundTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.CustomFormPopUp;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.TemplateKeyTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.editor.util.ConstraintValueEditorHelper;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.EnumDropDown;
import org.drools.workbench.screens.guided.rule.client.widget.ExpressionBuilder;
import org.guvnor.common.services.workingset.client.WorkingSetManager;
import org.guvnor.common.services.workingset.client.factconstraints.customform.CustomFormConfiguration;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.CEPOracle;
import org.kie.workbench.common.widgets.client.widget.PopupDatePicker;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.DropDownValueChanged;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class ConstraintValueEditor
extends Composite {
    private final ConstraintValueEditorHelper helper;
    private WorkingSetManager workingSetManager = null;
    private String factType;
    private CompositeFieldConstraint constraintList;
    private String fieldName;
    private String fieldType;
    private final AsyncPackageDataModelOracle oracle;
    private final BaseSingleFieldConstraint constraint;
    private final Panel panel = new SimplePanel();
    private final RuleModel model;
    private final RuleModeller modeller;
    private final EventBus eventBus;
    private DropDownData dropDownData;
    private boolean readOnly;
    private Command onValueChangeCommand;
    private Command onTemplateValueChangeCommand;
    private boolean isDropDownDataEnum;
    private Widget constraintWidget = null;
    private AddConstraintButton addConstraintButton = new AddConstraintButton(new ClickHandler(){

        public void onClick(ClickEvent event) {
            ConstraintValueEditor.this.showTypeChoice((Widget)event.getSource(), ConstraintValueEditor.this.constraint);
        }
    });

    public ConstraintValueEditor(BaseSingleFieldConstraint con, CompositeFieldConstraint constraintList, RuleModeller modeller, EventBus eventBus, boolean readOnly) {
        this.constraint = con;
        this.constraintList = constraintList;
        this.oracle = modeller.getDataModelOracle();
        this.model = modeller.getModel();
        this.modeller = modeller;
        this.eventBus = eventBus;
        this.readOnly = readOnly;
        this.setUpConstraint();
        this.helper = new ConstraintValueEditorHelper(this.model, this.oracle, this.factType, this.fieldName, this.constraint, this.fieldType, this.dropDownData);
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void setUpConstraint() {
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            this.setUpSingleFieldConstraintEBLeftSide((SingleFieldConstraintEBLeftSide)this.constraint);
        } else if (this.constraint instanceof ConnectiveConstraint) {
            this.setUpConnectiveConstraint((ConnectiveConstraint)this.constraint);
        } else if (this.constraint instanceof SingleFieldConstraint) {
            this.setUpSingleFieldConstraint((SingleFieldConstraint)this.constraint);
        }
    }

    private void setUpSingleFieldConstraint(SingleFieldConstraint sfc) {
        this.factType = sfc.getFactType();
        this.fieldName = sfc.getFieldName();
        this.fieldType = this.oracle.getFieldType(this.factType, this.fieldName);
    }

    private void setUpConnectiveConstraint(ConnectiveConstraint cc) {
        this.factType = cc.getFactType();
        this.fieldName = cc.getFieldName();
        this.fieldType = cc.getFieldType();
    }

    private void setUpSingleFieldConstraintEBLeftSide(SingleFieldConstraintEBLeftSide sfexp) {
        this.factType = sfexp.getExpressionLeftSide().getPreviousClassType();
        if (this.factType == null) {
            this.factType = sfexp.getExpressionLeftSide().getClassType();
        }
        this.fieldName = sfexp.getExpressionLeftSide().getFieldName();
        this.fieldType = sfexp.getExpressionLeftSide().getGenericType();
    }

    public BaseSingleFieldConstraint getConstraint() {
        return this.constraint;
    }

    public void refreshEditor() {
        this.panel.clear();
        this.constraintWidget = null;
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            this.setUpSingleFieldConstraintEBLeftSide((SingleFieldConstraintEBLeftSide)this.constraint);
        }
        this.getDropDownData();
        if (this.constraint.getConstraintValueType() == 0) {
            this.addAddConstraintButton();
        } else {
            this.addConstraintWidget();
        }
        this.panel.add(this.constraintWidget);
    }

    private void addConstraintWidget() {
        switch (this.constraint.getConstraintValueType()) {
            case 1: 
            case 4: {
                this.constraintWidget = this.wrap(this.literalEditor());
                break;
            }
            case 3: {
                this.constraintWidget = this.wrap(this.returnValueEditor());
                break;
            }
            case 6: {
                this.constraintWidget = this.wrap(this.expressionEditor());
                break;
            }
            case 2: {
                this.constraintWidget = this.wrap(this.variableEditor());
                break;
            }
            case 7: {
                this.constraintWidget = this.wrap(this.templateKeyEditor());
                break;
            }
        }
    }

    private void addAddConstraintButton() {
        this.addConstraintButton.setEnabled(!this.readOnly);
        this.constraintWidget = this.addConstraintButton;
    }

    public void showError() {
        this.addConstraintButton.showError();
    }

    public void hideError() {
        this.addConstraintButton.hideError();
    }

    private Widget wrap(Widget widget) {
        if (this.readOnly) {
            return widget;
        }
        HorizontalPanel wrapper = new HorizontalPanel();
        Image clear = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        clear.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveConstraintValueDefinition());
        clear.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveConstraintValueDefinitionQuestion())) {
                    ConstraintValueEditor.this.constraint.setConstraintValueType(0);
                    ConstraintValueEditor.this.constraint.setValue(null);
                    ConstraintValueEditor.this.constraint.clearParameters();
                    ConstraintValueEditor.this.constraint.setExpressionValue(new ExpressionFormLine());
                    ConstraintValueEditor.this.doTypeChosen();
                }
            }
        });
        wrapper.add(widget);
        if (!this.readOnly) {
            wrapper.add((Widget)clear);
            wrapper.setCellVerticalAlignment((Widget)clear, HasVerticalAlignment.ALIGN_MIDDLE);
        }
        return wrapper;
    }

    private String assertValue() {
        if (this.constraint.getValue() == null) {
            return "";
        }
        return this.constraint.getValue();
    }

    private Widget literalEditor() {
        String operator;
        if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint con = (SingleFieldConstraint)this.constraint;
            CustomFormConfiguration customFormConfiguration = this.getWorkingSetManager().getCustomFormConfiguration(this.modeller.getPath(), this.factType, this.fieldName);
            if (customFormConfiguration != null) {
                Button btnCustom = new Button(con.getValue(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ConstraintValueEditor.this.showTypeChoice((Widget)event.getSource(), ConstraintValueEditor.this.constraint);
                    }
                });
                btnCustom.setEnabled(!this.readOnly);
                return btnCustom;
            }
        }
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        if (this.dropDownData != null) {
            operator = this.constraint.getOperator();
            boolean multipleSelect = OperatorsOracle.operatorRequiresList((String)operator);
            EnumDropDown enumDropDown = new EnumDropDown(this.constraint.getValue(), new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    if (!newValue.equals(ConstraintValueEditor.this.constraint.getValue())) {
                        ConstraintValueEditor.this.constraint.setValue(newValue);
                        ConstraintValueEditor.this.executeOnValueChangeCommand();
                    }
                }
            }, this.dropDownData, multipleSelect, this.modeller.getPath());
            return enumDropDown;
        }
        operator = null;
        if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)this.constraint;
            operator = sfc.getOperator();
        }
        if (OperatorsOracle.operatorRequiresList((String)operator)) {
            TextBox box = TextBoxFactory.getTextBox((String)"String");
            box.setStyleName("constraint-value-Editor");
            box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    ConstraintValueEditor.this.constraint.setValue((String)event.getValue());
                    ConstraintValueEditor.this.executeOnValueChangeCommand();
                }
            });
            box.setText(this.assertValue());
            this.attachDisplayLengthHandler(box);
            return box;
        }
        boolean isCEPOperator = CEPOracle.isCEPOperator((String)this.constraint.getOperator());
        if ("Date".equals(this.fieldType) || "this".equals(this.fieldName) && isCEPOperator) {
            if (this.readOnly) {
                return new SmallLabel(this.constraint.getValue());
            }
            PopupDatePicker dp = new PopupDatePicker(false);
            dp.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    String value = PopupDatePicker.convertToString(event);
                    boolean update = ConstraintValueEditor.this.constraint.getValue() == null || !ConstraintValueEditor.this.constraint.getValue().equals(value);
                    ConstraintValueEditor.this.constraint.setValue(value);
                    if (update) {
                        ConstraintValueEditor.this.executeOnValueChangeCommand();
                    }
                }
            });
            dp.setValue(this.assertValue());
            return dp;
        }
        TextBox box = TextBoxFactory.getTextBox((String)this.fieldType);
        box.setStyleName("constraint-value-Editor");
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ConstraintValueEditor.this.constraint.setValue((String)event.getValue());
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        box.setText(this.assertValue());
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private Widget variableEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.constraint.getValue());
        }
        final ListBox box = new ListBox();
        box.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        List bindingsInScope = this.model.getBoundVariablesInScope(this.constraint);
        Iterator i$ = bindingsInScope.iterator();
        while (i$.hasNext()) {
            String var;
            final String binding = var = (String)i$.next();
            this.helper.isApplicableBindingsInScope(var, new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.TRUE.equals(result)) {
                        box.addItem(binding);
                        if (ConstraintValueEditor.this.constraint.getValue() != null && ConstraintValueEditor.this.constraint.getValue().equals(binding)) {
                            box.setSelectedIndex(box.getItemCount() - 1);
                        }
                    }
                }
            });
        }
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
                int selectedIndex = box.getSelectedIndex();
                if (selectedIndex > 0) {
                    ConstraintValueEditor.this.constraint.setValue(box.getItemText(selectedIndex));
                } else {
                    ConstraintValueEditor.this.constraint.setValue(null);
                }
            }
        });
        return box;
    }

    private Widget returnValueEditor() {
        BoundTextBox box = new BoundTextBox(this.constraint);
        if (this.readOnly) {
            return new SmallLabel(box.getText());
        }
        String msg = GuidedRuleEditorResources.CONSTANTS.FormulaEvaluateToAValue();
        Image img = new Image(GuidedRuleEditorResources.INSTANCE.images().functionAssets());
        img.setTitle(msg);
        box.setTitle(msg);
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent event) {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        Panel ed = this.widgets((IsWidget)img, (IsWidget)box);
        return ed;
    }

    private Widget expressionEditor() {
        ExpressionBuilder builder = null;
        builder = new ExpressionBuilder(this.modeller, this.eventBus, this.constraint.getExpressionValue(), this.readOnly);
        builder.addOnModifiedCommand(new Command(){

            public void execute() {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        Panel ed = this.widgets((IsWidget)new HTML("&nbsp;"), (IsWidget)builder);
        return ed;
    }

    private Widget templateKeyEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TemplateKeyTextBox box = new TemplateKeyTextBox();
        box.setStyleName("constraint-value-Editor");
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ConstraintValueEditor.this.constraint.setValue((String)event.getValue());
                ConstraintValueEditor.this.executeOnTemplateValueChangeCommand();
            }
        });
        box.setValue(this.assertValue(), true);
        this.attachDisplayLengthHandler((TextBox)box);
        return box;
    }

    private void attachDisplayLengthHandler(final TextBox box) {
        int length = box.getText().length();
        box.setVisibleLength(length > 0 ? length : 1);
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                int length = box.getText().length();
                box.setVisibleLength(length > 0 ? length : 1);
            }
        });
    }

    private void showTypeChoice(Widget w, final BaseSingleFieldConstraint con) {
        List bindingsInScope;
        ConnectiveConstraint cc;
        String fieldName;
        boolean showExpressionSelector;
        CustomFormConfiguration customFormConfiguration = this.getWorkingSetManager().getCustomFormConfiguration(this.modeller.getPath(), this.factType, this.fieldName);
        if (customFormConfiguration != null) {
            if (!(con instanceof SingleFieldConstraint)) {
                Window.alert((String)"Unexpected constraint type!");
                return;
            }
            final CustomFormPopUp customFormPopUp = new CustomFormPopUp(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.FieldValue(), customFormConfiguration);
            final SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            customFormPopUp.addOkButtonHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    sfc.setConstraintValueType(1);
                    sfc.setId(customFormPopUp.getFormId());
                    sfc.setValue(customFormPopUp.getFormValue());
                    ConstraintValueEditor.this.doTypeChosen(customFormPopUp);
                }
            });
            customFormPopUp.show(sfc.getId(), sfc.getValue());
            return;
        }
        final FormStylePopup form = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.FieldValue());
        Button lit = new Button(GuidedRuleEditorResources.CONSTANTS.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                con.setConstraintValueType(ConstraintValueEditor.this.isDropDownDataEnum && ConstraintValueEditor.this.dropDownData != null ? 4 : 1);
                ConstraintValueEditor.this.doTypeChosen(form);
            }
        });
        boolean showLiteralSelector = true;
        boolean showFormulaSelector = !OperatorsOracle.operatorRequiresList((String)con.getOperator());
        boolean showVariableSelector = !OperatorsOracle.operatorRequiresList((String)con.getOperator());
        boolean bl = showExpressionSelector = !OperatorsOracle.operatorRequiresList((String)con.getOperator());
        if (con instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            fieldName = sfc.getFieldName();
            if (fieldName.equals("this")) {
                showLiteralSelector = CEPOracle.isCEPOperator((String)sfc.getOperator());
                showFormulaSelector = showFormulaSelector && showLiteralSelector;
            }
        } else if (con instanceof ConnectiveConstraint && (fieldName = (cc = (ConnectiveConstraint)con).getFieldName()).equals("this")) {
            showLiteralSelector = CEPOracle.isCEPOperator((String)cc.getOperator());
            boolean bl2 = showFormulaSelector = showFormulaSelector && showLiteralSelector;
        }
        if (showLiteralSelector) {
            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.LiteralValue() + ":", (IsWidget)this.widgets((IsWidget)lit, (IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.LiteralValue(), GuidedRuleEditorResources.CONSTANTS.LiteralValTip())));
        }
        if (this.modeller.isTemplate()) {
            String templateKeyLabel = GuidedRuleEditorResources.CONSTANTS.TemplateKey();
            Button templateKeyButton = new Button(templateKeyLabel);
            templateKeyButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(7);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(templateKeyLabel + ":", (IsWidget)this.widgets((IsWidget)templateKeyButton, (IsWidget)new InfoPopup(templateKeyLabel, GuidedRuleEditorResources.CONSTANTS.LiteralValTip())));
        }
        if (showVariableSelector || showFormulaSelector || showExpressionSelector) {
            form.addRow((Widget)new HTML("<hr/>"));
            form.addRow((Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.AdvancedOptions()));
        }
        if (showVariableSelector && ((bindingsInScope = this.model.getBoundVariablesInScope(this.constraint)).size() > 0 || "Collection".equals(this.fieldType))) {
            final Button bindingButton = new Button(GuidedRuleEditorResources.CONSTANTS.BoundVariable());
            final HashSet bindingButtonContainer = new HashSet();
            for (String var : bindingsInScope) {
                this.helper.isApplicableBindingsInScope(var, new Callback<Boolean>(){

                    public void callback(Boolean result) {
                        if (Boolean.TRUE.equals(result) && !bindingButtonContainer.contains(bindingButton)) {
                            bindingButtonContainer.add(bindingButton);
                            bindingButton.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    con.setConstraintValueType(2);
                                    ConstraintValueEditor.this.doTypeChosen(form);
                                }
                            });
                            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.AVariable(), (IsWidget)ConstraintValueEditor.this.widgets((IsWidget)bindingButton, (IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.ABoundVariable(), GuidedRuleEditorResources.CONSTANTS.BoundVariableTip())));
                        }
                    }
                });
            }
        }
        if (showFormulaSelector) {
            Button formula = new Button(GuidedRuleEditorResources.CONSTANTS.NewFormula());
            formula.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(3);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.AFormula() + ":", (IsWidget)this.widgets((IsWidget)formula, (IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.AFormula(), GuidedRuleEditorResources.CONSTANTS.FormulaExpressionTip())));
        }
        if (showExpressionSelector) {
            Button expression = new Button(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor());
            expression.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(6);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor() + ":", (IsWidget)this.widgets((IsWidget)expression, (IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor(), GuidedRuleEditorResources.CONSTANTS.ExpressionEditor())));
        }
        form.show();
    }

    private void doTypeChosen() {
        this.executeOnValueChangeCommand();
        this.executeOnTemplateVariablesChange();
        this.refreshEditor();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.doTypeChosen();
        form.hide();
    }

    private Panel widgets(IsWidget left, IsWidget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public void setOnTemplateValueChangeCommand(Command onTemplateValueChangeCommand) {
        this.onTemplateValueChangeCommand = onTemplateValueChangeCommand;
    }

    private void executeOnTemplateValueChangeCommand() {
        if (this.onTemplateValueChangeCommand != null) {
            this.onTemplateValueChangeCommand.execute();
        }
    }

    private DropDownData getDropDownData() {
        if ("Boolean".equals(this.fieldType)) {
            this.isDropDownDataEnum = false;
            this.dropDownData = DropDownData.create((String[])new String[]{"true", "false"});
        } else {
            this.isDropDownDataEnum = true;
            HashMap<String, String> currentValueMap = new HashMap<String, String>();
            if (this.constraintList != null && this.constraintList.getConstraints() != null) {
                for (FieldConstraint con : this.constraintList.getConstraints()) {
                    if (!(con instanceof SingleFieldConstraint)) continue;
                    SingleFieldConstraint sfc = (SingleFieldConstraint)con;
                    String fieldName = sfc.getFieldName();
                    currentValueMap.put(fieldName, sfc.getValue());
                }
            }
            this.dropDownData = this.oracle.getEnums(this.factType, this.fieldName, currentValueMap);
        }
        return this.dropDownData;
    }

    private void executeOnTemplateVariablesChange() {
        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(this.model);
        this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)this.model);
    }

    private WorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = (WorkingSetManager)IOC.getBeanManager().lookupBean(WorkingSetManager.class, new Annotation[0]).getInstance();
        }
        return this.workingSetManager;
    }
}

