/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.kie.workbench.common.widgets.client.resources.ItemImages;
import org.kie.workbench.common.widgets.client.widget.PopupDatePicker;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class RuleAttributeWidget
extends Composite {
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String TIMER_ATTR = "timer";
    public static final String CALENDARS_ATTR = "calendars";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String LOCK_LHS = "freeze_conditions";
    public static final String LOCK_RHS = "freeze_actions";
    public static final String DEFAULT_DIALECT = "mvel";
    public static final String[] DIALECTS = new String[]{"java", "mvel"};
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private RuleModel model;
    private RuleModeller parent;

    public RuleAttributeWidget(RuleModeller parent, RuleModel model, boolean isReadOnly) {
        this.parent = parent;
        this.model = model;
        FormStyleLayout layout = new FormStyleLayout();
        RuleMetadata[] meta = model.metadataList;
        if (meta.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.Metadata2()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < meta.length; ++i) {
            RuleMetadata rmd = meta[i];
            layout.addAttribute(rmd.getAttributeName(), (IsWidget)this.getEditorWidget(rmd, i, isReadOnly));
        }
        RuleAttribute[] attrs = model.attributes;
        if (attrs.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.Attributes1()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < attrs.length; ++i) {
            RuleAttribute at = attrs[i];
            layout.addAttribute(at.getAttributeName(), (IsWidget)this.getEditorWidget(at, i, isReadOnly));
        }
        this.initWidget((Widget)layout);
    }

    public static ListBox getAttributeList() {
        ListBox list = new ListBox();
        list.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        list.addItem(SALIENCE_ATTR);
        list.addItem(ENABLED_ATTR);
        list.addItem(DATE_EFFECTIVE_ATTR);
        list.addItem(DATE_EXPIRES_ATTR);
        list.addItem(NO_LOOP_ATTR);
        list.addItem(AGENDA_GROUP_ATTR);
        list.addItem(ACTIVATION_GROUP_ATTR);
        list.addItem(DURATION_ATTR);
        list.addItem(TIMER_ATTR);
        list.addItem(CALENDARS_ATTR);
        list.addItem(AUTO_FOCUS_ATTR);
        list.addItem(LOCK_ON_ACTIVE_ATTR);
        list.addItem(RULEFLOW_GROUP_ATTR);
        list.addItem(DIALECT_ATTR);
        return list;
    }

    private Widget getEditorWidget(final RuleAttribute at, int idx, boolean isReadOnly) {
        TextBox tb;
        TextBox editor = null;
        String attributeName = at.getAttributeName();
        if (attributeName.equals(RULEFLOW_GROUP_ATTR) || attributeName.equals(AGENDA_GROUP_ATTR) || attributeName.equals(ACTIVATION_GROUP_ATTR) || attributeName.equals(TIMER_ATTR) || attributeName.equals(CALENDARS_ATTR)) {
            tb = TextBoxFactory.getTextBox((String)"String");
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        at.setValue(tb.getValue());
                    }
                });
            }
            tb.setValue((Object)at.getValue());
            editor = tb;
        } else if (attributeName.equals(SALIENCE_ATTR)) {
            tb = TextBoxFactory.getTextBox((String)"Integer");
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        at.setValue(tb.getValue());
                    }
                });
            }
            tb.setValue((Object)at.getValue());
            editor = tb;
        } else if (attributeName.equals(DURATION_ATTR)) {
            tb = TextBoxFactory.getTextBox((String)"Long");
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        at.setValue(tb.getValue());
                    }
                });
            }
            tb.setValue((Object)at.getValue());
            editor = tb;
        } else if (attributeName.equals(NO_LOOP_ATTR) || attributeName.equals(LOCK_ON_ACTIVE_ATTR) || attributeName.equals(AUTO_FOCUS_ATTR) || attributeName.equals(ENABLED_ATTR)) {
            editor = this.checkBoxEditor(at, isReadOnly);
        } else if (attributeName.equals(DATE_EFFECTIVE_ATTR) || attributeName.equals(DATE_EXPIRES_ATTR)) {
            if (isReadOnly) {
                tb = TextBoxFactory.getTextBox((String)"String");
                tb.setValue((Object)at.getValue());
                tb.setEnabled(false);
            } else {
                PopupDatePicker dp = new PopupDatePicker(false);
                dp.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                    public void onValueChange(ValueChangeEvent<Date> event) {
                        at.setValue(PopupDatePicker.convertToString(event));
                    }
                });
                dp.setValue(at.getValue());
                editor = dp;
            }
        } else if (attributeName.equals(DIALECT_ATTR)) {
            final ListBox lb = new ListBox();
            lb.addItem(DIALECTS[0]);
            lb.addItem(DIALECTS[1]);
            lb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                lb.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        int selectedIndex = lb.getSelectedIndex();
                        if (selectedIndex < 0) {
                            return;
                        }
                        at.setValue(lb.getValue(selectedIndex));
                    }
                });
            }
            if (at.getValue() == null || at.getValue().isEmpty()) {
                lb.setSelectedIndex(1);
                at.setValue(DIALECTS[1]);
            } else if (at.getValue().equals(DIALECTS[0])) {
                lb.setSelectedIndex(0);
            } else if (at.getValue().equals(DIALECTS[1])) {
                lb.setSelectedIndex(1);
            } else {
                lb.setSelectedIndex(1);
                at.setValue(DIALECTS[1]);
            }
            editor = lb;
        }
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        if (editor != null) {
            horiz.add((Widget)editor);
            if (!isReadOnly) {
                horiz.add((Widget)this.getRemoveIcon(idx));
            }
        }
        return horiz;
    }

    private Widget getEditorWidget(RuleMetadata rm, int idx, boolean isReadOnly) {
        Object editor = rm.getAttributeName().equals(LOCK_LHS) || rm.getAttributeName().equals(LOCK_RHS) ? new InfoPopup(GuidedRuleEditorResources.CONSTANTS.FrozenAreas(), GuidedRuleEditorResources.CONSTANTS.FrozenExplanation()) : this.textBoxEditor(rm, isReadOnly);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((IsWidget)editor);
        if (!isReadOnly) {
            horiz.add((Widget)this.getRemoveMetaIcon(idx));
        }
        return horiz;
    }

    private Widget checkBoxEditor(final RuleAttribute at, boolean isReadOnly) {
        final CheckBox box = new CheckBox();
        box.setEnabled(!isReadOnly);
        if (at.getValue() == null || at.getValue().isEmpty()) {
            box.setValue(Boolean.valueOf(false));
            at.setValue(FALSE_VALUE);
        } else {
            box.setValue(Boolean.valueOf(at.getValue().equals(TRUE_VALUE)));
        }
        box.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                at.setValue(box.getValue() != false ? RuleAttributeWidget.TRUE_VALUE : RuleAttributeWidget.FALSE_VALUE);
            }
        });
        return box;
    }

    private TextBox textBoxEditor(final RuleMetadata rm, boolean isReadOnly) {
        final TextBox box = new TextBox();
        box.setEnabled(!isReadOnly);
        box.setVisibleLength(rm.getValue().length() < 3 ? 3 : rm.getValue().length());
        box.setText(rm.getValue());
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                rm.setValue(box.getText());
            }
        });
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                box.setVisibleLength(box.getText().length());
            }
        });
        return box;
    }

    private Image getRemoveIcon(final int idx) {
        Image remove = new Image(ItemImages.INSTANCE.deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeAttribute(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }

    private Image getRemoveMetaIcon(final int idx) {
        Image remove = new Image(ItemImages.INSTANCE.deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeMetadata(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }
}

