/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.ExpressionCollection;
import org.drools.workbench.models.datamodel.rule.ExpressionField;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionGlobalVariable;
import org.drools.workbench.models.datamodel.rule.ExpressionMethod;
import org.drools.workbench.models.datamodel.rule.ExpressionMethodParameter;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;

public class ExpressionPartHelper {
    public static void getExpressionPartForMethod(AsyncPackageDataModelOracle oracle, String factName, String methodNameWithParams, final Callback<ExpressionPart> callback) {
        oracle.getMethodInfo(factName, methodNameWithParams, (Callback)new Callback<MethodInfo>(){

            public void callback(MethodInfo mi) {
                if ("Collection".equals(mi.getGenericType())) {
                    callback.callback((Object)new ExpressionCollection(mi.getName(), mi.getReturnClassType(), mi.getGenericType(), mi.getParametricReturnType()));
                } else {
                    ExpressionMethod em = new ExpressionMethod(mi.getName(), mi.getReturnClassType(), mi.getGenericType(), mi.getParametricReturnType());
                    for (int index = 0; index < mi.getParams().size(); ++index) {
                        String paramDataType = (String)mi.getParams().get(index);
                        ExpressionFormLine param = new ExpressionFormLine(index);
                        param.appendPart((ExpressionPart)new ExpressionMethodParameter("", paramDataType, paramDataType));
                        em.putParam(paramDataType, param);
                    }
                    callback.callback((Object)em);
                }
            }
        });
    }

    public static void getExpressionPartForField(final AsyncPackageDataModelOracle oracle, final String factName, final String fieldName, final Callback<ExpressionPart> callback) {
        final String fieldClassName = oracle.getFieldClassName(factName, fieldName);
        final String fieldGenericType = oracle.getFieldType(factName, fieldName);
        oracle.getFieldCompletions(fieldClassName, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] result) {
                if ("Collection".equals(fieldGenericType)) {
                    String fieldParametricType = oracle.getParametricFieldType(factName, fieldName);
                    callback.callback((Object)new ExpressionCollection(fieldName, fieldClassName, fieldGenericType, fieldParametricType));
                } else {
                    callback.callback((Object)new ExpressionField(fieldName, fieldClassName, fieldGenericType));
                }
            }
        });
    }

    public static void getExpressionPartForGlobalVariable(AsyncPackageDataModelOracle oracle, final String varName, final Callback<ExpressionPart> callback) {
        final String globalVarType = oracle.getGlobalVariable(varName);
        oracle.getFieldCompletions(globalVarType, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] result) {
                callback.callback((Object)new ExpressionGlobalVariable(varName, globalVarType, globalVarType));
            }
        });
    }
}

