/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.AttributeSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleAttributeWidget;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.gwtbootstrap3.client.ui.Button;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;

public class GuidedRuleAttributeSelectorPopup
extends AttributeSelectorPopup {
    private final RuleModel model;
    private final Command refresh;

    public GuidedRuleAttributeSelectorPopup(RuleModel model, boolean lockLHS, boolean lockRHS, Command refresh) {
        this.model = model;
        this.refresh = refresh;
        this.initialize();
        this.setFreezePanel(lockLHS, lockRHS);
    }

    @Override
    protected String[] getAttributes() {
        return RuleAttributeWidget.getAttributesList();
    }

    @Override
    protected String[] getDuplicates() {
        int size = this.model.attributes.length;
        String[] duplicates = new String[size];
        for (int i = 0; i < size; ++i) {
            duplicates[i] = this.model.attributes[i].getAttributeName();
        }
        return duplicates;
    }

    @Override
    protected void handleAttributeAddition(String attributeName) {
        if (attributeName.equals("freeze_conditions") || attributeName.equals("freeze_actions")) {
            this.model.addMetadata(new RuleMetadata(attributeName, "true"));
        } else {
            this.model.addAttribute(new RuleAttribute(attributeName, ""));
        }
        this.refresh.execute();
    }

    @Override
    protected boolean isMetadataUnique(String metadataName) {
        for (RuleMetadata rm : this.model.metadataList) {
            if (!rm.getAttributeName().equals(metadataName)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String metadataNotUniqueMessage(String metadataName) {
        return GuidedRuleEditorResources.CONSTANTS.MetadataNotUnique0(metadataName);
    }

    @Override
    protected void handleMetadataAddition(String metadataName) {
        this.model.addMetadata(new RuleMetadata(metadataName, ""));
        this.refresh.execute();
    }

    private void setFreezePanel(boolean lockLHS, boolean lockRHS) {
        HorizontalPanel hz = new HorizontalPanel();
        if (!lockLHS) {
            hz.add((Widget)this.createFreezeButton(GuidedRuleEditorResources.CONSTANTS.Conditions(), "freeze_conditions"));
        }
        if (!lockRHS) {
            hz.add((Widget)this.createFreezeButton(GuidedRuleEditorResources.CONSTANTS.Actions(), "freeze_actions"));
        }
        hz.add((IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.FrozenAreas(), GuidedRuleEditorResources.CONSTANTS.FrozenExplanation()));
        if (hz.getWidgetCount() > 1) {
            this.addAttribute(GuidedRuleEditorResources.CONSTANTS.FreezeAreasForEditing(), (IsWidget)hz);
        }
    }

    private Button createFreezeButton(String text, String metadataName) {
        return new Button(text, event -> {
            this.model.addMetadata(new RuleMetadata(metadataName, "true"));
            this.refresh.execute();
            this.hide();
        });
    }
}

