/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.attribute;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.EditAttributeWidgetFactory;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.resources.ItemImages;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class RuleAttributeWidget
extends Composite {
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String TIMER_ATTR = "timer";
    public static final String CALENDARS_ATTR = "calendars";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String LOCK_LHS = "freeze_conditions";
    public static final String LOCK_RHS = "freeze_actions";
    public static final String[] DIALECTS = new String[]{"java", "mvel"};
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private RuleModel model;
    private RuleModeller parent;

    public RuleAttributeWidget(RuleModeller parent, RuleModel model, boolean isReadOnly) {
        this.parent = parent;
        this.model = model;
        FormStyleLayout layout = (FormStyleLayout)GWT.create(FormStyleLayout.class);
        RuleMetadata[] meta = model.metadataList;
        if (meta.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.Metadata2()));
            layout.addRow((IsWidget)hp);
        }
        for (int i = 0; i < meta.length; ++i) {
            RuleMetadata rmd = meta[i];
            layout.addAttribute(RuleAttributeWidget.translateMetadataIfTranslationsIsKnown(rmd.getAttributeName()), (IsWidget)this.getEditorWidget(rmd, i, isReadOnly));
        }
        RuleAttribute[] attrs = model.attributes;
        if (attrs.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.Attributes1()));
            layout.addRow((IsWidget)hp);
        }
        for (int i = 0; i < attrs.length; ++i) {
            RuleAttribute at = attrs[i];
            layout.addAttribute(at.getAttributeName(), (IsWidget)this.getEditorWidget(at, i, isReadOnly));
        }
        this.initWidget((Widget)layout);
    }

    public static String[] getAttributesList() {
        return new String[]{GuidedRuleEditorResources.CONSTANTS.Choose(), SALIENCE_ATTR, ENABLED_ATTR, DATE_EFFECTIVE_ATTR, DATE_EXPIRES_ATTR, NO_LOOP_ATTR, AGENDA_GROUP_ATTR, ACTIVATION_GROUP_ATTR, DURATION_ATTR, TIMER_ATTR, CALENDARS_ATTR, AUTO_FOCUS_ATTR, LOCK_ON_ACTIVE_ATTR, RULEFLOW_GROUP_ATTR, DIALECT_ATTR};
    }

    private Widget getEditorWidget(final RuleAttribute at, int idx, boolean isReadOnly) {
        Object editor = null;
        EditAttributeWidgetFactory editAttributeWidgetFactory = new EditAttributeWidgetFactory(isReadOnly);
        String attributeName = at.getAttributeName();
        if (attributeName.equals(RULEFLOW_GROUP_ATTR) || attributeName.equals(AGENDA_GROUP_ATTR) || attributeName.equals(ACTIVATION_GROUP_ATTR) || attributeName.equals(TIMER_ATTR) || attributeName.equals(CALENDARS_ATTR)) {
            editor = editAttributeWidgetFactory.textBox(at, "String");
        } else if (attributeName.equals(SALIENCE_ATTR)) {
            editor = editAttributeWidgetFactory.textBox(at, "Integer");
        } else if (attributeName.equals(DURATION_ATTR)) {
            editor = editAttributeWidgetFactory.textBox(at, "Long");
        } else if (attributeName.equals(NO_LOOP_ATTR) || attributeName.equals(LOCK_ON_ACTIVE_ATTR) || attributeName.equals(AUTO_FOCUS_ATTR) || attributeName.equals(ENABLED_ATTR)) {
            editor = this.checkBoxEditor(at, isReadOnly);
        } else if (attributeName.equals(DATE_EFFECTIVE_ATTR) || attributeName.equals(DATE_EXPIRES_ATTR)) {
            editor = isReadOnly ? editAttributeWidgetFactory.textBox(at, "String") : editAttributeWidgetFactory.datePicker(at, false);
        } else if (attributeName.equals(DIALECT_ATTR)) {
            final ListBox lb = new ListBox();
            lb.addItem(DIALECTS[0]);
            lb.addItem(DIALECTS[1]);
            lb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                lb.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        int selectedIndex = lb.getSelectedIndex();
                        if (selectedIndex < 0) {
                            return;
                        }
                        at.setValue(lb.getValue(selectedIndex));
                    }
                });
            }
            if (at.getValue() == null || at.getValue().isEmpty()) {
                lb.setSelectedIndex(1);
                at.setValue(DIALECTS[1]);
            } else if (at.getValue().equals(DIALECTS[0])) {
                lb.setSelectedIndex(0);
            } else if (at.getValue().equals(DIALECTS[1])) {
                lb.setSelectedIndex(1);
            } else {
                lb.setSelectedIndex(1);
                at.setValue(DIALECTS[1]);
            }
            editor = lb;
        }
        DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)GWT.create(DirtyableHorizontalPane.class);
        if (editor != null) {
            horiz.add((Widget)editor);
            if (!isReadOnly) {
                horiz.add((Widget)this.getRemoveIcon(idx));
            }
        }
        return horiz;
    }

    private Widget getEditorWidget(RuleMetadata rm, int idx, boolean isReadOnly) {
        Object editor = rm.getAttributeName().equals(LOCK_LHS) || rm.getAttributeName().equals(LOCK_RHS) ? new InfoPopup(GuidedRuleEditorResources.CONSTANTS.FrozenAreas(), GuidedRuleEditorResources.CONSTANTS.FrozenExplanation()) : this.textBoxEditor(rm, isReadOnly);
        DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)GWT.create(DirtyableHorizontalPane.class);
        horiz.add((IsWidget)editor);
        if (!isReadOnly) {
            horiz.add((Widget)this.getRemoveMetaIcon(idx));
        }
        return horiz;
    }

    private Widget checkBoxEditor(final RuleAttribute at, boolean isReadOnly) {
        final CheckBox box = new CheckBox();
        box.setEnabled(!isReadOnly);
        if (at.getValue() == null || at.getValue().isEmpty()) {
            box.setValue(Boolean.valueOf(false));
            at.setValue(FALSE_VALUE);
        } else {
            box.setValue(Boolean.valueOf(at.getValue().equals(TRUE_VALUE)));
        }
        box.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                at.setValue(box.getValue() != false ? RuleAttributeWidget.TRUE_VALUE : RuleAttributeWidget.FALSE_VALUE);
            }
        });
        return box;
    }

    private TextBox textBoxEditor(final RuleMetadata rm, boolean isReadOnly) {
        final TextBox box = (TextBox)GWT.create(TextBox.class);
        box.setEnabled(!isReadOnly);
        ((InputElement)box.getElement().cast()).setSize(rm.getValue().length() < 3 ? 3 : rm.getValue().length());
        box.setText(rm.getValue());
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                rm.setValue(box.getText());
            }
        });
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                ((InputElement)box.getElement().cast()).setSize(box.getText().length());
            }
        });
        return box;
    }

    private Image getRemoveIcon(final int idx) {
        Image remove = new Image(ItemImages.INSTANCE.deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeAttribute(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }

    private Image getRemoveMetaIcon(final int idx) {
        Image remove = new Image(ItemImages.INSTANCE.deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeMetadata(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }

    private static String translateMetadataIfTranslationsIsKnown(String metadata) {
        if (Objects.equals(metadata, LOCK_LHS)) {
            return GuidedRuleEditorResources.CONSTANTS.FrozenConditions();
        }
        if (Objects.equals(metadata, LOCK_RHS)) {
            return GuidedRuleEditorResources.CONSTANTS.FrozenActions();
        }
        return metadata;
    }
}

