/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public abstract class AttributeSelectorPopup
extends FormStylePopup {
    protected TextBox box;
    protected ListBox list;

    public AttributeSelectorPopup() {
        this(GuidedRuleEditorImages508.INSTANCE.Configure(), GuidedRuleEditorResources.CONSTANTS.AddAnOptionToTheRule());
    }

    public AttributeSelectorPopup(Image icon, String title) {
        super(icon, title);
    }

    protected final void initialize() {
        this.initialize(new TextBox(), new ListBox());
    }

    protected final void initialize(TextBox box, ListBox list) {
        this.box = box;
        this.list = list;
        this.setMetadataPanel();
        this.setAttributesPanel();
    }

    private void setMetadataPanel() {
        this.box.getElement().setAttribute("size", "15");
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)this.box);
        horiz.add((Widget)this.getAddButton());
        this.addAttribute(GuidedRuleEditorResources.CONSTANTS.Metadata3(), (IsWidget)horiz);
    }

    private void setAttributesPanel() {
        for (String item : this.getAttributes()) {
            this.list.addItem(item);
        }
        this.removeReservedAttributes();
        this.list.setSelectedIndex(0);
        this.list.addChangeHandler(this.getListHandler(this.list));
        this.addAttribute(GuidedRuleEditorResources.CONSTANTS.Attribute1(), (IsWidget)this.list);
    }

    private void removeReservedAttributes() {
        block0: for (String reservedAttribute : this.getReservedAttributes()) {
            for (int iItem = 0; iItem < this.list.getItemCount(); ++iItem) {
                if (!this.list.getItemText(iItem).equals(reservedAttribute)) continue;
                this.list.removeItem(iItem);
                continue block0;
            }
        }
    }

    protected abstract String[] getAttributes();

    protected abstract String[] getReservedAttributes();

    private ChangeHandler getListHandler(ListBox list) {
        return event -> {
            this.handleAttributeAddition(list.getSelectedItemText());
            this.hide();
        };
    }

    protected abstract void handleAttributeAddition(String var1);

    protected Image getAddButton() {
        Image addbutton = GuidedRuleEditorImages508.INSTANCE.NewItem();
        addbutton.setAltText(GuidedRuleEditorResources.CONSTANTS.AddMetadataToTheRule());
        addbutton.setTitle(GuidedRuleEditorResources.CONSTANTS.AddMetadataToTheRule());
        addbutton.addClickHandler(this.getMetadataHandler());
        return addbutton;
    }

    protected ClickHandler getMetadataHandler() {
        return event -> {
            String metaData = this.box.getText().trim();
            if (metaData.isEmpty()) {
                Window.alert((String)GuidedRuleEditorResources.CONSTANTS.MetadataNameEmpty());
                return;
            }
            if (!this.isMetadataUnique(metaData)) {
                Window.alert((String)this.metadataNotUniqueMessage(metaData));
                return;
            }
            this.handleMetadataAddition(metaData);
            this.hide();
        };
    }

    protected abstract boolean isMetadataUnique(String var1);

    protected abstract String metadataNotUniqueMessage(String var1);

    protected abstract void handleMetadataAddition(String var1);
}

