/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.attribute;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.ext.widgets.common.client.common.DatePicker;

public class EditAttributeWidgetFactory {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);
    final boolean isReadOnly;

    public EditAttributeWidgetFactory(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public TextBox textBox(RuleAttribute ruleAttribute, String dataType) {
        TextBox textBox = TextBoxFactory.getTextBox((String)dataType);
        this.initTextBoxByRuleAttribute(textBox, ruleAttribute);
        return textBox;
    }

    public DatePicker datePicker(RuleAttribute ruleAttribute, boolean allowEmptyValues) {
        DatePicker datePicker = new DatePicker(allowEmptyValues);
        this.initDatePickerByRuleAttribute(datePicker, ruleAttribute);
        return datePicker;
    }

    protected void initTextBoxByRuleAttribute(TextBox textBox, RuleAttribute ruleAttribute) {
        textBox.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            textBox.addValueChangeHandler(event -> ruleAttribute.setValue(textBox.getValue()));
        }
        textBox.setValue((Object)ruleAttribute.getValue());
    }

    protected void initDatePickerByRuleAttribute(DatePicker datePicker, RuleAttribute ruleAttribute) {
        datePicker.addValueChangeHandler(event -> {
            Date date = datePicker.getValue();
            String sDate = date == null ? null : DATE_FORMATTER.format(datePicker.getValue());
            ruleAttribute.setValue(sDate);
        });
        datePicker.setFormat(DATE_FORMAT);
        datePicker.setValue(this.assertDateValue(ruleAttribute));
    }

    private Date assertDateValue(RuleAttribute ruleAttribute) {
        if (ruleAttribute == null || ruleAttribute.getValue() == null) {
            return null;
        }
        try {
            Date d = DATE_FORMATTER.parse(ruleAttribute.getValue());
            return d;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

