/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.HasCEPWindow;
import org.drools.workbench.models.datamodel.rule.HasConstraints;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.models.datamodel.rule.builder.DRLConstraintValueBuilder;
import org.drools.workbench.models.datamodel.rule.visitors.ToStringExpressionVisitor;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionTypeChangeEvent;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionTypeChangeHandler;
import org.drools.workbench.screens.guided.rule.client.editor.MoveDownButton;
import org.drools.workbench.screens.guided.rule.client.editor.MoveUpButton;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.factPattern.Connectives;
import org.drools.workbench.screens.guided.rule.client.editor.factPattern.PopupCreator;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.util.RefreshUtil;
import org.drools.workbench.screens.guided.rule.client.widget.ExpressionBuilder;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.drools.workbench.screens.guided.rule.client.widget.operator.SingleFieldConstraintOperatorSelector;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class FactPatternWidget
extends RuleModellerWidget {
    private final Map<SingleFieldConstraint, ConstraintValueEditor> constraintValueEditors = new HashMap<SingleFieldConstraint, ConstraintValueEditor>();
    private FactPattern pattern;
    private FlexTable layout = new FlexTable();
    private Connectives connectives;
    private PopupCreator popupCreator;
    private boolean bindable;
    private boolean isAll0WithLabel;
    private boolean readOnly;
    private boolean isFactTypeKnown;
    private ConstraintValueEditor constraintValueEditor;

    public FactPatternWidget(RuleModeller ruleModeller, EventBus eventBus, IPattern pattern, boolean canBind, Boolean readOnly) {
        this(ruleModeller, eventBus, pattern, false, canBind, readOnly);
    }

    public FactPatternWidget(RuleModeller mod, EventBus eventBus, IPattern p, boolean isAll0WithLabel, boolean canBind, Boolean readOnly) {
        super(mod, eventBus);
        this.pattern = (FactPattern)p;
        this.bindable = canBind;
        this.popupCreator = new PopupCreator();
        this.popupCreator.setBindable(this.bindable);
        this.popupCreator.setDataModelOracle(mod.getDataModelOracle());
        this.popupCreator.setModeller(mod);
        this.popupCreator.setPattern(this.pattern);
        this.isAll0WithLabel = isAll0WithLabel;
        this.isFactTypeKnown = mod.getDataModelOracle().isFactTypeRecognized(this.pattern.getFactType());
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        this.connectives = new Connectives(mod, eventBus, this.pattern, this.readOnly);
        this.layout.setWidget(0, 0, this.getPatternLabel(this.pattern));
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_BOTTOM);
        formatter.setStyleName(0, 0, "modeller-fact-TypeHeader");
        List<FieldConstraint> sortedConst = this.sortConstraints(this.pattern.getFieldConstraints());
        this.pattern.setFieldConstraints(sortedConst);
        this.drawConstraints(sortedConst, (HasConstraints)this.pattern);
        int row = this.layout.getRowCount() + 1;
        this.layout.setWidget(row, 0, this.createCEPWindowWidget(mod, (HasCEPWindow)this.pattern));
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.initWidget((Widget)this.layout);
    }

    protected void drawConstraints(List<FieldConstraint> sortedConst, HasConstraints hasConstraints) {
        FlexTable table = new FlexTable();
        this.layout.setWidget(1, 0, (Widget)table);
        ArrayList<FieldConstraint> parents = new ArrayList<FieldConstraint>();
        for (int i = 0; i < sortedConst.size(); ++i) {
            this.traverseSingleFieldConstraints(sortedConst, table, parents, hasConstraints, i);
            int currentRow = i;
            Image clear = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
            clear.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisWholeRestriction());
            clear.addClickHandler(this.createClickHandlerForClearImageButton(currentRow));
            if (this.readOnly) continue;
            table.setWidget(currentRow, 6, (Widget)clear);
            table.setWidget(currentRow, 7, (Widget)new MoveUpButton(event -> {
                hasConstraints.moveUp(currentRow);
                this.getModeller().refreshWidget();
            }));
            table.setWidget(currentRow, 8, (Widget)new MoveDownButton(event -> {
                hasConstraints.moveDown(currentRow);
                this.getModeller().refreshWidget();
            }));
        }
    }

    private ClickHandler createClickHandlerForClearImageButton(final int currentRow) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItem())) {
                    FactPatternWidget.this.setModified(true);
                    FactPatternWidget.this.pattern.removeConstraint(currentRow);
                    FactPatternWidget.this.getModeller().refreshWidget();
                }
            }
        };
    }

    private void traverseSingleFieldConstraints(List<FieldConstraint> sortedConst, FlexTable table, List<FieldConstraint> parents, HasConstraints hasConstraints, int i) {
        int tabs = -1;
        FieldConstraint current = sortedConst.get(i);
        if (current instanceof SingleFieldConstraint) {
            SingleFieldConstraint single = (SingleFieldConstraint)current;
            FieldConstraint parent = single.getParent();
            for (int j = 0; j < parents.size(); ++j) {
                FieldConstraint storedParent = parents.get(j);
                if (storedParent == null || !storedParent.equals(parent)) continue;
                tabs = j + 1;
                this.traverseForRemoval(parents, j);
                parents.add(current);
                break;
            }
            if (tabs < 0) {
                tabs = 0;
                parents.add(current);
            }
        }
        this.renderFieldConstraint(table, i, current, hasConstraints, true, tabs);
    }

    private void traverseForRemoval(List<FieldConstraint> parents, int j) {
        for (int k = j + 1; k < parents.size(); ++k) {
            parents.remove(j + 1);
        }
    }

    private List<FieldConstraint> sortConstraints(FieldConstraint[] constraints) {
        ArrayList<FieldConstraint> sortedConst = new ArrayList<FieldConstraint>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            FieldConstraint current = constraints[i];
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                int index = sortedConst.indexOf(single.getParent());
                if (single.getParent() == null) {
                    sortedConst.add((FieldConstraint)single);
                    continue;
                }
                if (index >= 0) {
                    sortedConst.add(index + 1, (FieldConstraint)single);
                    continue;
                }
                this.insertSingleFieldConstraint(single, sortedConst);
                continue;
            }
            sortedConst.add(current);
        }
        return sortedConst;
    }

    private void insertSingleFieldConstraint(SingleFieldConstraint fieldConst, List<FieldConstraint> sortedConst) {
        if (fieldConst.getParent() instanceof SingleFieldConstraint) {
            this.insertSingleFieldConstraint((SingleFieldConstraint)fieldConst.getParent(), sortedConst);
        }
        sortedConst.add((FieldConstraint)fieldConst);
    }

    private void renderFieldConstraint(FlexTable inner, int row, FieldConstraint constraint, HasConstraints hasConstraints, boolean showBinding, int tabs) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(inner, row, (SingleFieldConstraint)constraint, hasConstraints, showBinding, tabs);
        } else if (constraint instanceof CompositeFieldConstraint) {
            inner.setWidget(row, 1, this.compositeFieldConstraintEditor((CompositeFieldConstraint)constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
            inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        }
    }

    private Widget compositeFieldConstraintEditor(final CompositeFieldConstraint constraint) {
        FlexTable t = new FlexTable();
        String desc = null;
        ClickHandler click = new ClickHandler(){

            public void onClick(ClickEvent event) {
                FactPatternWidget.this.popupCreator.showPatternPopupForComposite((HasConstraints)constraint);
            }
        };
        desc = constraint.getCompositeJunctionType().equals("&&") ? GuidedRuleEditorResources.CONSTANTS.AllOf() + ":" : GuidedRuleEditorResources.CONSTANTS.AnyOf() + ":";
        t.setWidget(0, 0, (Widget)new ClickableLabel(desc, click, !this.readOnly));
        t.getFlexCellFormatter().setColSpan(0, 0, 2);
        FieldConstraint[] nested = constraint.getConstraints();
        FlexTable inner = new FlexTable();
        if (nested != null) {
            for (int i = 0; i < nested.length; ++i) {
                int currentId = i;
                this.renderFieldConstraint(inner, i, nested[i], (HasConstraints)constraint, true, 0);
                final int currentRow = i;
                Image clear = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
                clear.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisNestedRestriction());
                clear.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItemFromNestedConstraint())) {
                            FactPatternWidget.this.setModified(true);
                            constraint.removeConstraint(currentRow);
                            FactPatternWidget.this.getModeller().refreshWidget();
                        }
                    }
                });
                if (this.readOnly) continue;
                inner.setWidget(i, 6, (Widget)clear);
                inner.setWidget(i, 7, (Widget)new MoveDownButton(event -> {
                    constraint.moveDown(currentRow);
                    this.getModeller().refreshWidget();
                }));
                inner.setWidget(i, 8, (Widget)new MoveUpButton(event -> {
                    constraint.moveUp(currentRow);
                    this.getModeller().refreshWidget();
                }));
            }
        }
        t.setWidget(1, 1, (Widget)inner);
        t.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        return t;
    }

    private void renderSingleFieldConstraint(FlexTable inner, int row, SingleFieldConstraint constraint, HasConstraints hasConstraints, boolean showBinding, int tabs) {
        boolean col = true;
        inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (constraint.getConstraintValueType() != 5) {
            HorizontalPanel ebContainer = null;
            if (constraint instanceof SingleFieldConstraintEBLeftSide) {
                ebContainer = this.expressionBuilderLS((SingleFieldConstraintEBLeftSide)constraint, showBinding);
                inner.setWidget(row, 1, (Widget)ebContainer);
            } else {
                inner.setWidget(row, 1, this.fieldLabel(constraint, hasConstraints, showBinding, tabs * 20));
            }
            inner.setWidget(row, 2, this.operatorDropDown(constraint, inner, row, 3));
            inner.setWidget(row, 3, (Widget)this.createValueEditor(constraint));
            inner.setWidget(row, 4, this.getConnectives().connectives(constraint));
            if (ebContainer != null && ebContainer.getWidgetCount() > 0 && ebContainer.getWidget(0) instanceof ExpressionBuilder) {
                this.associateExpressionWithChangeHandler(inner, row, constraint, 1, ebContainer);
            }
        } else if (constraint.getConstraintValueType() == 5) {
            inner.setWidget(row, 1, this.predicateEditor(constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
        }
    }

    private Widget createCEPWindowWidget(RuleModeller modeller, final HasCEPWindow c) {
        final HorizontalPanel hp = new HorizontalPanel();
        modeller.getDataModelOracle().isFactTypeAnEvent(this.pattern.getFactType(), (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (Boolean.TRUE.equals(result)) {
                    Label lbl = new Label(HumanReadableConstants.INSTANCE.OverCEPWindow());
                    lbl.setStyleName("paddedLabel");
                    hp.add((Widget)lbl);
                    CEPWindowOperatorsDropdown cwo = new CEPWindowOperatorsDropdown(c, FactPatternWidget.this.readOnly);
                    if (!FactPatternWidget.this.isReadOnly()) {
                        cwo.addValueChangeHandler(new ValueChangeHandler<OperatorSelection>(){

                            public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                                FactPatternWidget.this.setModified(true);
                                OperatorSelection selection = (OperatorSelection)event.getValue();
                                String selected = selection.getValue();
                                c.getWindow().setOperator(selected);
                            }
                        });
                    }
                    hp.add((Widget)cwo);
                }
            }
        });
        return hp;
    }

    private void associateExpressionWithChangeHandler(final FlexTable inner, final int row, final SingleFieldConstraint constraint, final int col, HorizontalPanel ebContainer) {
        ExpressionBuilder eb = (ExpressionBuilder)ebContainer.getWidget(0);
        eb.addExpressionTypeChangeHandler(new ExpressionTypeChangeHandler(){

            @Override
            public void onExpressionTypeChanged(ExpressionTypeChangeEvent event) {
                try {
                    constraint.setFieldType(event.getNewType());
                    inner.setWidget(row, 1 + col, FactPatternWidget.this.operatorDropDown(constraint, inner, row, 2 + col));
                    constraint.setConstraintValueType(0);
                    constraint.setValue("");
                    inner.setWidget(row, 2 + col, (Widget)FactPatternWidget.this.createValueEditor(constraint));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private Widget predicateEditor(final SingleFieldConstraint c) {
        HorizontalPanel pred = new HorizontalPanel();
        pred.setWidth("100%");
        Image img = new Image(GuidedRuleEditorResources.INSTANCE.images().functionAssets());
        img.setTitle(GuidedRuleEditorResources.CONSTANTS.FormulaBooleanTip());
        pred.add((Widget)img);
        if (c.getValue() == null) {
            c.setValue("");
        }
        final TextBox box = new TextBox();
        box.setText(c.getValue());
        if (!this.readOnly) {
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    FactPatternWidget.this.setModified(true);
                    c.setValue(box.getText());
                }
            });
            box.setWidth("100%");
            pred.add((Widget)box);
        } else {
            pred.add((Widget)new SmallLabel(c.getValue()));
        }
        return pred;
    }

    private Widget getPatternLabel(final FactPattern fp) {
        String desc;
        String patternName;
        ClickHandler click = new ClickHandler(){

            public void onClick(ClickEvent event) {
                FactPatternWidget.this.popupCreator.showPatternPopup(fp, null, false);
            }
        };
        String string = patternName = this.pattern.isBound() ? this.pattern.getFactType() + " <b>[" + this.pattern.getBoundName() + "]</b>" : this.pattern.getFactType();
        if (this.isAll0WithLabel) {
            desc = GuidedRuleEditorResources.CONSTANTS.All0with(patternName);
        } else {
            desc = this.pattern.getNumberOfConstraints() > 0 ? GuidedRuleEditorResources.CONSTANTS.ThereIsAAn0With(patternName) : GuidedRuleEditorResources.CONSTANTS.ThereIsAAn0(patternName);
            desc = this.anA(desc, patternName);
        }
        return new ClickableLabel(desc, click, !this.readOnly);
    }

    private String anA(String desc, String patternName) {
        if (desc.startsWith("There is a/an")) {
            String vowel = patternName.substring(0, 1);
            if (vowel.equalsIgnoreCase("A") || vowel.equalsIgnoreCase("E") || vowel.equalsIgnoreCase("I") || vowel.equalsIgnoreCase("O") || vowel.equalsIgnoreCase("U")) {
                return desc.replace("There is a/an", "There is an");
            }
            return desc.replace("There is a/an", "There is a");
        }
        return desc;
    }

    ConstraintValueEditor createValueEditor(final SingleFieldConstraint constraint) {
        this.constraintValueEditor = this.constraintValueEditor(constraint);
        this.constraintValueEditor.init();
        this.constraintValueEditor.setOnValueChangeCommand(new Command(){

            public void execute() {
                FactPatternWidget.this.constraintValueEditor.hideError();
                FactPatternWidget.this.setModified(true);
                RefreshUtil.refreshConstraintValueEditorsDropDownData(FactPatternWidget.this.constraintValueEditors, constraint);
            }
        });
        this.constraintValueEditor.setOnTemplateValueChangeCommand(new Command(){

            public void execute() {
                FactPatternWidget.this.constraintValueEditor.hideError();
                FactPatternWidget.this.setModified(true);
            }
        });
        this.constraintValueEditors.put(constraint, this.constraintValueEditor);
        return this.constraintValueEditor;
    }

    private Widget operatorDropDown(SingleFieldConstraint constraint, FlexTable inner, int rowIndex, int colIndex) {
        HorizontalPanel dropdownContainer = new HorizontalPanel();
        if (!this.readOnly) {
            SingleFieldConstraintOperatorSelector operatorSelectorBuilder = (SingleFieldConstraintOperatorSelector)GWT.create(SingleFieldConstraintOperatorSelector.class);
            operatorSelectorBuilder.configure(constraint, () -> this.constraintValueEditor, this::createValueEditor, this, dropdownContainer, inner, rowIndex, colIndex, this.getConnectives().getDataModelOracle());
        } else {
            SmallLabel sl = new SmallLabel("<b>" + (constraint.getOperator() == null ? GuidedRuleEditorResources.CONSTANTS.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)constraint.getOperator())) + "</b>");
            dropdownContainer.add((Widget)sl);
        }
        return dropdownContainer;
    }

    private HorizontalPanel expressionBuilderLS(SingleFieldConstraintEBLeftSide con, boolean showBinding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding && !this.readOnly) {
                ab.add((Widget)new ExpressionBuilder(this.getModeller(), this.getEventBus(), con.getExpressionLeftSide()));
            } else {
                DRLConstraintValueBuilder constraintValueBuilder = DRLConstraintValueBuilder.getBuilder((String)this.getRuleDialect());
                ToStringExpressionVisitor visitor = new ToStringExpressionVisitor(constraintValueBuilder);
                ab.add((Widget)new SmallLabel(con.getExpressionLeftSide().getText(visitor)));
            }
        } else {
            ab.add((Widget)new ExpressionBuilder(this.getModeller(), this.getEventBus(), con.getExpressionLeftSide()));
        }
        return ab;
    }

    private Widget fieldLabel(final SingleFieldConstraint con, HasConstraints hasConstraints, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        StringBuilder bindingLabel = new StringBuilder();
        if (con.isBound()) {
            bindingLabel.append("<b>[");
            bindingLabel.append(con.getFieldBinding());
            bindingLabel.append("]</b>&nbsp;");
        }
        String fieldName = con.getFieldName();
        bindingLabel.append(fieldName);
        if (this.bindable && showBinding && !this.readOnly) {
            ClickHandler click = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String fieldName = con.getFieldName();
                    if ("this".equals(fieldName)) {
                        FactPatternWidget.this.getConnectives().getDataModelOracle().getFieldCompletions(FactPatternWidget.this.pattern.getFactType(), (Callback)new Callback<ModelField[]>(){

                            public void callback(ModelField[] fields) {
                                FactPatternWidget.this.popupCreator.showBindFieldPopup(FactPatternWidget.this.pattern, con, fields, FactPatternWidget.this.popupCreator);
                            }
                        });
                    } else {
                        FactPatternWidget.this.getConnectives().getDataModelOracle().getFieldCompletions(con.getFieldType(), (Callback)new Callback<ModelField[]>(){

                            public void callback(ModelField[] fields) {
                                FactPatternWidget.this.popupCreator.showBindFieldPopup(FactPatternWidget.this.pattern, con, fields, FactPatternWidget.this.popupCreator);
                            }
                        });
                    }
                }
            };
            ClickableLabel cl = new ClickableLabel(bindingLabel.toString(), click, !this.readOnly);
            DOM.setStyleAttribute((Element)cl.getElement(), (String)"marginLeft", (String)("" + padding + "pt"));
            ab.add((Widget)cl);
        } else {
            ab.add((Widget)new SmallLabel(bindingLabel.toString()));
        }
        return ab;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    private String getRuleDialect() {
        RuleModel model = this.getModeller().getModel();
        for (int i = 0; i < model.attributes.length; ++i) {
            RuleAttribute attr = model.attributes[i];
            if (!attr.getAttributeName().equals("dialect")) continue;
            return attr.getValue();
        }
        return "mvel";
    }

    Connectives getConnectives() {
        return this.connectives;
    }

    ConstraintValueEditor constraintValueEditor(SingleFieldConstraint constraint) {
        return new ConstraintValueEditor((BaseSingleFieldConstraint)constraint, this.pattern.getConstraintList(), this.getModeller(), this.getEventBus(), this.readOnly);
    }
}

