/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.guvnor.common.services.workingset.client.factconstraints.customform.CustomFormConfiguration;
import org.gwtbootstrap3.client.ui.Button;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class CustomFormPopUp
extends FormStylePopup {
    private final CustomFormConfiguration configuration;
    private final Button okButton;
    private final Button cancelButton;
    private Frame externalFrame;

    public CustomFormPopUp(Image image, String title, CustomFormConfiguration configuration) {
        super(image, title);
        this.configuration = configuration;
        this.externalFrame = new Frame();
        this.externalFrame.setWidth(configuration.getCustomFormWidth() + "px");
        this.externalFrame.setHeight(configuration.getCustomFormHeight() + "px");
        VerticalPanel vp = new VerticalPanel();
        vp.setWidth("100%");
        vp.setHeight("100%");
        vp.add((Widget)this.externalFrame);
        this.okButton = new Button(GuidedRuleEditorResources.CONSTANTS.OK());
        this.cancelButton = new Button(GuidedRuleEditorResources.CONSTANTS.Cancel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomFormPopUp.this.hide();
            }
        });
        HorizontalPanel hp = new HorizontalPanel();
        hp.setWidth("100%");
        hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        hp.add((Widget)this.okButton);
        hp.add((Widget)this.cancelButton);
        vp.add((Widget)hp);
        this.addRow((IsWidget)vp);
    }

    public void addOkButtonHandler(ClickHandler handler) {
        this.okButton.addClickHandler(handler);
    }

    public void addCancelButtonHandler(ClickHandler handler) {
        this.cancelButton.addClickHandler(handler);
    }

    public void show(String selectedId, String selectedValue) {
        String url = this.configuration.getCustomFormURL();
        if (url == null || url.trim().equals("")) {
            return;
        }
        String parameters = "cf_id=" + selectedId + "&cf_value=" + selectedValue + "&factType=" + this.configuration.getFactType() + "&fieldName=" + this.configuration.getFieldName();
        url = url + (url.contains("?") ? "&" : "?") + parameters;
        this.externalFrame.setUrl(url);
        this.show();
    }

    private Element getExternalFrameElement(String id) {
        IFrameElement iframe = IFrameElement.as((Element)this.externalFrame.getElement());
        return iframe.getContentDocument().getElementById(id);
    }

    public String getFormId() {
        return this.getExternalFrameElement("cf_id").getPropertyString("value");
    }

    public String getFormValue() {
        return this.getExternalFrameElement("cf_value").getPropertyString("value");
    }
}

