/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldNature;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.TemplateKeyTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.util.FieldNatureUtil;
import org.drools.workbench.screens.guided.rule.client.widget.EnumDropDown;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.DropDownValueChanged;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class ActionValueEditor
extends Composite {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);
    private String factType;
    private ActionFieldValue value;
    private ActionFieldValue[] values;
    private DropDownData dropDownData;
    private SimplePanel root;
    private RuleModeller modeller;
    private RuleModel model;
    private AsyncPackageDataModelOracle oracle;
    private EventBus eventBus;
    private String variableType = null;
    private boolean readOnly;
    private Command onChangeCommand;

    public ActionValueEditor(String factType, ActionFieldValue value, ActionFieldValue[] values, RuleModeller modeller, EventBus eventBus, String variableType, boolean readOnly) {
        this.readOnly = readOnly;
        this.root = new SimplePanel();
        this.factType = factType;
        this.value = value;
        this.values = values;
        this.modeller = modeller;
        this.model = modeller.getModel();
        this.oracle = modeller.getDataModelOracle();
        this.eventBus = eventBus;
        this.variableType = variableType;
        this.refresh();
        this.initWidget((Widget)this.root);
    }

    public void refresh() {
        this.root.clear();
        this.getDropDownData();
        if (this.value.getNature() == 0) {
            if (this.value.getValue() != null && this.value.getValue().length() > 0) {
                if (this.value.getValue().charAt(0) == '=') {
                    this.value.setNature(2);
                } else {
                    this.value.setNature(1);
                }
            } else {
                this.root.add(this.choice());
                return;
            }
        }
        if (this.value.getNature() == 7) {
            Widget box = this.wrap(this.templateKeyEditor());
            this.root.add(box);
            return;
        }
        if (this.value.getNature() == 2) {
            Widget list = this.wrap(this.boundVariable());
            this.root.add(list);
            return;
        }
        if (this.dropDownData != null && (this.dropDownData.getFixedList() != null || this.dropDownData.getQueryExpression() != null)) {
            Widget list = this.wrap(this.enumEditor());
            this.root.add(list);
            return;
        }
        if (this.value.getNature() == 3) {
            Widget box = this.wrap(this.formulaEditor());
            this.root.add(box);
            return;
        }
        Widget box = this.wrap(this.literalEditor());
        this.root.add(box);
    }

    private Widget wrap(Widget w) {
        HorizontalPanel wrapper = new HorizontalPanel();
        Image clear = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
        clear.setAltText(GuidedRuleEditorResources.CONSTANTS.RemoveActionValueDefinition());
        clear.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveActionValueDefinition());
        clear.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveActionValueDefinitionQuestion())) {
                    ActionValueEditor.this.value.setNature(0);
                    ActionValueEditor.this.value.setValue(null);
                    ActionValueEditor.this.doTypeChosen();
                }
            }
        });
        wrapper.add(w);
        if (!this.readOnly) {
            wrapper.add((Widget)clear);
            wrapper.setCellVerticalAlignment((Widget)clear, HasVerticalAlignment.ALIGN_MIDDLE);
        }
        return wrapper;
    }

    private void doTypeChosen() {
        this.executeOnChangeCommand();
        this.executeOnTemplateVariablesChange();
        this.refresh();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.doTypeChosen();
        form.hide();
    }

    private Widget boundVariable() {
        ListBox listVariable = new ListBox();
        listVariable.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        List<String> bindings = this.getApplicableBindings();
        for (String v : bindings) {
            listVariable.addItem(v);
        }
        if (this.value.getValue().equals("=")) {
            listVariable.setSelectedIndex(0);
        } else {
            for (int i = 0; i < listVariable.getItemCount(); ++i) {
                if (!listVariable.getItemText(i).equals(this.value.getValue().substring(1))) continue;
                listVariable.setSelectedIndex(i);
            }
        }
        if (listVariable.getItemCount() > 0) {
            listVariable.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ListBox w = (ListBox)event.getSource();
                    ActionValueEditor.this.value.setValue("=" + w.getValue(w.getSelectedIndex()));
                    ActionValueEditor.this.executeOnChangeCommand();
                    ActionValueEditor.this.refresh();
                }
            });
        }
        if (this.readOnly) {
            return new SmallLabel(listVariable.getItemText(listVariable.getSelectedIndex()));
        }
        return listVariable;
    }

    private String assertValue() {
        if (this.value.getValue() == null) {
            return "";
        }
        return this.value.getValue();
    }

    private Date assertDateValue() {
        if (this.value.getValue() == null) {
            return null;
        }
        try {
            return DATE_FORMATTER.parse(this.value.getValue());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private Widget enumEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        EnumDropDown enumDropDown = new EnumDropDown(this.value.getValue(), new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                ActionValueEditor.this.value.setValue(newValue);
                ActionValueEditor.this.executeOnChangeCommand();
            }
        }, this.dropDownData, this.modeller.getPath());
        return enumDropDown;
    }

    private Widget literalEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        if ("Date".equals(this.value.getType())) {
            final DatePicker datePicker = new DatePicker(false);
            datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    Date date = datePicker.getValue();
                    String sDate = date == null ? null : DATE_FORMATTER.format(datePicker.getValue());
                    ActionValueEditor.this.value.setValue(sDate);
                }
            });
            datePicker.setFormat(DATE_FORMAT);
            datePicker.setValue(this.assertDateValue());
            return datePicker;
        }
        TextBox box = TextBoxFactory.getTextBox((String)this.value.getType());
        box.setStyleName("constraint-value-Editor");
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ActionValueEditor.this.value.setValue((String)event.getValue());
                ActionValueEditor.this.executeOnChangeCommand();
            }
        });
        box.setText(this.assertValue());
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private Widget templateKeyEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TemplateKeyTextBox box = new TemplateKeyTextBox();
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ActionValueEditor.this.value.setValue((String)event.getValue());
                ActionValueEditor.this.executeOnChangeCommand();
            }
        });
        box.setValue(this.assertValue(), true);
        this.attachDisplayLengthHandler((TextBox)box);
        return box;
    }

    private Widget formulaEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TextBox box = new TextBox();
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ActionValueEditor.this.value.setValue((String)event.getValue());
                ActionValueEditor.this.executeOnChangeCommand();
            }
        });
        box.setValue((Object)this.assertValue(), true);
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private void attachDisplayLengthHandler(final TextBox box) {
        int length = box.getText().length();
        ((InputElement)box.getElement().cast()).setSize(length > 0 ? length : 1);
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                int length = box.getText().length();
                ((InputElement)box.getElement().cast()).setSize(length > 0 ? length : 1);
            }
        });
    }

    private Widget choice() {
        if (this.readOnly) {
            return new HTML();
        }
        Image clickme = GuidedRuleEditorImages508.INSTANCE.Edit();
        clickme.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionValueEditor.this.showTypeChoice((Widget)event.getSource());
            }
        });
        return clickme;
    }

    protected void showTypeChoice(Widget w) {
        final FormStylePopup form = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.FieldValue());
        Button lit = new Button(GuidedRuleEditorResources.CONSTANTS.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionValueEditor.this.value.setNature(1);
                ActionValueEditor.this.value.setValue("");
                ActionValueEditor.this.doTypeChosen(form);
            }
        });
        form.addAttribute(GuidedRuleEditorResources.CONSTANTS.LiteralValue() + ":", (IsWidget)this.widgets(lit, new InfoPopup(GuidedRuleEditorResources.CONSTANTS.Literal(), GuidedRuleEditorResources.CONSTANTS.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        if (this.modeller.isTemplate()) {
            Button templateButton = new Button(GuidedRuleEditorResources.CONSTANTS.TemplateKey());
            templateButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ActionValueEditor.this.value.setNature(7);
                    ActionValueEditor.this.value.setValue("");
                    ActionValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.TemplateKey() + ":", (IsWidget)this.widgets(templateButton, new InfoPopup(GuidedRuleEditorResources.CONSTANTS.Literal(), GuidedRuleEditorResources.CONSTANTS.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        }
        form.addRow((IsWidget)new HTML("<hr/>"));
        form.addRow((IsWidget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.AdvancedSection()));
        Button formula = new Button(GuidedRuleEditorResources.CONSTANTS.Formula());
        formula.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionValueEditor.this.value.setNature(3);
                ActionValueEditor.this.doTypeChosen(form);
            }
        });
        List<String> bindings = this.getApplicableBindings();
        if (bindings.size() > 0) {
            Button variable = new Button(GuidedRuleEditorResources.CONSTANTS.BoundVariable());
            form.addAttribute(GuidedRuleEditorResources.CONSTANTS.BoundVariable() + ":", (IsWidget)variable);
            variable.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ActionValueEditor.this.value.setNature(2);
                    ActionValueEditor.this.value.setValue("=");
                    ActionValueEditor.this.doTypeChosen(form);
                }
            });
        }
        form.addAttribute(GuidedRuleEditorResources.CONSTANTS.Formula() + ":", (IsWidget)this.widgets(formula, new InfoPopup(GuidedRuleEditorResources.CONSTANTS.Formula(), GuidedRuleEditorResources.CONSTANTS.FormulaTip())));
        form.show();
    }

    private List<String> getApplicableBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (String v : this.modeller.getModel().getAllVariables()) {
            ActionInsertFact aif;
            SingleFieldConstraint fc;
            FactPattern fp = this.modeller.getModel().getLHSBoundFact(v);
            if (fp != null && this.isLHSFactTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((fc = this.modeller.getModel().getLHSBoundField(v)) != null && this.isLHSFieldTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((aif = this.modeller.getModel().getRHSBoundFact(v)) == null || !this.isRHSFieldTypeEquivalent(v)) continue;
            bindings.add(v);
        }
        return bindings;
    }

    private boolean isLHSFactTypeEquivalent(String boundVariable) {
        String boundFactType = this.modeller.getModel().getLHSBoundFact(boundVariable).getFactType();
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.modeller.getDataModelOracle().getEnumValues(boundFactType, this.value.getField());
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isLHSFieldTypeEquivalent(String boundVariable) {
        String boundFieldType = this.modeller.getModel().getLHSBindingType(boundVariable);
        if (boundFieldType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            SingleFieldConstraint fc = this.modeller.getModel().getLHSBoundField(boundVariable);
            String fieldName = fc.getFieldName();
            String parentFactTypeForBinding = this.modeller.getModel().getLHSParentFactPatternForBinding(boundVariable).getFactType();
            String[] dd = this.modeller.getDataModelOracle().getEnumValues(parentFactTypeForBinding, fieldName);
            return this.isEnumEquivalent(dd);
        }
        return boundFieldType.equals(this.variableType);
    }

    private boolean isRHSFieldTypeEquivalent(String boundVariable) {
        String boundFactType = this.modeller.getModel().getRHSBoundFact(boundVariable).getFactType();
        if (boundFactType == null) {
            return false;
        }
        if (this.variableType == null) {
            return false;
        }
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.modeller.getDataModelOracle().getEnumValues(boundFactType, this.value.getField());
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isEnumEquivalent(String[] values) {
        if (values == null || this.dropDownData.getFixedList() == null) {
            return false;
        }
        if (values.length != this.dropDownData.getFixedList().length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(this.dropDownData.getFixedList()[i])) continue;
            return false;
        }
        return true;
    }

    private Widget widgets(Button lit, InfoPopup popup) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)lit);
        h.add((IsWidget)popup);
        return h;
    }

    private void executeOnChangeCommand() {
        if (this.onChangeCommand != null) {
            this.onChangeCommand.execute();
        }
    }

    public Command getOnChangeCommand() {
        return this.onChangeCommand;
    }

    public void setOnChangeCommand(Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
    }

    private DropDownData getDropDownData() {
        if ("Boolean".equals(this.value.getType())) {
            this.dropDownData = DropDownData.create((String[])new String[]{"true", "false"});
        } else {
            Map<String, String> currentValueMap = FieldNatureUtil.toMap((FieldNature[])this.values);
            this.dropDownData = this.oracle.getEnums(this.factType, this.value.getField(), currentValueMap);
        }
        return this.dropDownData;
    }

    private void executeOnTemplateVariablesChange() {
        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(this.model);
        this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)this.model);
    }
}

