/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.GuidedRuleEditorView;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.validator.GuidedRuleEditorValidator;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.type.GuidedRuleDRLResourceType;
import org.drools.workbench.screens.guided.rule.client.type.GuidedRuleDSLRResourceType;
import org.drools.workbench.screens.guided.rule.model.GuidedEditorContent;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.source.ViewSourceView;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="GuidedRuleEditor", supportedTypes={GuidedRuleDRLResourceType.class, GuidedRuleDSLRResourceType.class}, priority=102)
public class GuidedRuleEditorPresenter
extends KieEditor {
    @Inject
    private ImportsWidgetPresenter importsWidget;
    private GuidedRuleEditorView view;
    @Inject
    private ViewSourceView viewSource;
    @Inject
    private Caller<GuidedRuleEditorService> service;
    @Inject
    private Caller<RuleNamesService> ruleNamesService;
    @Inject
    private GuidedRuleDRLResourceType resourceTypeDRL;
    @Inject
    private GuidedRuleDSLRResourceType resourceTypeDSL;
    @Inject
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Inject
    private ValidationPopup validationPopup;
    @Inject
    private ManagedInstance<RuleModellerActionPlugin> actionPluginInstance;
    private boolean isDSLEnabled;
    private RuleModel model;
    private AsyncPackageDataModelOracle oracle;

    @Inject
    public GuidedRuleEditorPresenter(GuidedRuleEditorView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, this.getResourceType((Path)path));
        this.isDSLEnabled = this.resourceTypeDSL.accept((Path)path);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((GuidedRuleEditorService)this.getService().call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.getVersionRecordManager().getCurrentPath());
    }

    public void onSourceTabSelected() {
        ((GuidedRuleEditorService)this.getService().call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GuidedRuleEditorPresenter.this.updateSource(source);
            }
        })).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    private RemoteCallback<GuidedEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<GuidedEditorContent>(){

            public void callback(GuidedEditorContent content) {
                if (GuidedRuleEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                GuidedRuleEditorPresenter.this.model = content.getModel();
                PackageDataModelOracleBaselinePayload dataModel = content.getDataModel();
                GuidedRuleEditorPresenter.this.oracle = GuidedRuleEditorPresenter.this.oracleFactory.makeAsyncPackageDataModelOracle((Path)GuidedRuleEditorPresenter.this.versionRecordManager.getCurrentPath(), (HasImports)GuidedRuleEditorPresenter.this.model, dataModel);
                GuidedRuleEditorPresenter.this.resetEditorPages(content.getOverview());
                GuidedRuleEditorPresenter.this.addSourcePage();
                GuidedRuleEditorPresenter.this.addImportsTab((IsWidget)GuidedRuleEditorPresenter.this.importsWidget);
                ArrayList<RuleModellerActionPlugin> actionPlugins = new ArrayList<RuleModellerActionPlugin>();
                GuidedRuleEditorPresenter.this.actionPluginInstance.forEach(actionPlugins::add);
                GuidedRuleEditorPresenter.this.view.setContent(GuidedRuleEditorPresenter.this.model, actionPlugins, GuidedRuleEditorPresenter.this.oracle, (Caller<RuleNamesService>)GuidedRuleEditorPresenter.this.ruleNamesService, GuidedRuleEditorPresenter.this.isReadOnly, GuidedRuleEditorPresenter.this.isDSLEnabled);
                GuidedRuleEditorPresenter.this.importsWidget.setContent(GuidedRuleEditorPresenter.this.oracle, GuidedRuleEditorPresenter.this.model.getImports(), GuidedRuleEditorPresenter.this.isReadOnly);
                GuidedRuleEditorPresenter.this.view.hideBusyIndicator();
                GuidedRuleEditorPresenter.this.createOriginalHash(GuidedRuleEditorPresenter.this.model);
            }
        };
    }

    public void handleImportAddedEvent(@Observes ImportAddedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        this.view.refresh();
    }

    public void handleImportRemovedEvent(@Observes ImportRemovedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        this.view.refresh();
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((GuidedRuleEditorService)GuidedRuleEditorPresenter.this.getService().call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            GuidedRuleEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            GuidedRuleEditorPresenter.this.validationPopup.showMessages(results);
                        }
                    }
                })).validate((Path)GuidedRuleEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)GuidedRuleEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save() {
        GuidedRuleEditorValidator validator = new GuidedRuleEditorValidator(this.model, GuidedRuleEditorResources.CONSTANTS);
        if (validator.isValid()) {
            this.savePopUpPresenter.show((Path)this.versionRecordManager.getPathToLatest(), (ParameterizedCommand)new ParameterizedCommand<String>(){

                public void execute(String commitMessage) {
                    GuidedRuleEditorPresenter.this.view.showSaving();
                    GuidedRuleEditorPresenter.this.save(commitMessage);
                }
            });
            this.concurrentUpdateSessionInfo = null;
        } else {
            ErrorPopup.showMessage((String)validator.getErrors().get(0));
        }
    }

    protected void save(String commitMessage) {
        ((GuidedRuleEditorService)this.getService().call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        this.oracleFactory.destroy(this.oracle);
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    private ClientResourceType getResourceType(Path path) {
        if (this.resourceTypeDRL.accept(path)) {
            return this.resourceTypeDRL;
        }
        return this.resourceTypeDRL;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    Caller<GuidedRuleEditorService> getService() {
        return this.service;
    }
}

