/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor.util;

import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.CEPOracle;
import org.uberfire.client.callbacks.Callback;

public class ConstraintValueEditorHelper {
    private final RuleModel model;
    private final AsyncPackageDataModelOracle oracle;
    private final String factType;
    private final String fieldName;
    private final BaseSingleFieldConstraint constraint;
    private final String fieldType;
    private final DropDownData dropDownData;

    public ConstraintValueEditorHelper(RuleModel model, AsyncPackageDataModelOracle oracle, String factType, String fieldName, BaseSingleFieldConstraint constraint, String fieldType, DropDownData dropDownData) {
        this.model = model;
        this.oracle = oracle;
        this.factType = factType;
        this.fieldName = fieldName;
        this.constraint = constraint;
        this.fieldType = fieldType;
        this.dropDownData = dropDownData;
    }

    public void isBoundVariableApplicable(final String boundVariable, final Callback<Boolean> callback) {
        this.isBoundVariableApplicableByField(boundVariable, new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    callback.callback((Object)true);
                    return;
                }
                ConstraintValueEditorHelper.this.isBoundVariableApplicableByFactType(boundVariable, (Callback<Boolean>)callback);
            }
        });
    }

    public void isApplicableBindingsInScope(final String binding, final Callback<Boolean> callback) {
        this.isLHSFactTypeEquivalent(binding, new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    callback.callback((Object)true);
                    return;
                }
                ConstraintValueEditorHelper.this.isBoundVariableApplicableByField(binding, (Callback<Boolean>)callback);
            }
        });
    }

    private void isBoundVariableApplicableByField(final String boundVariable, final Callback<Boolean> callback) {
        this.isLHSFieldTypeEquivalent(boundVariable, new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    callback.callback((Object)true);
                } else {
                    SingleFieldConstraint lhsBoundField = ConstraintValueEditorHelper.this.model.getLHSBoundField(boundVariable);
                    if (lhsBoundField != null) {
                        String boundClassName = ConstraintValueEditorHelper.this.oracle.getFieldClassName(lhsBoundField.getFactType(), lhsBoundField.getFieldName());
                        if (ConstraintValueEditorHelper.this.getFieldTypeClazz().equals(boundClassName)) {
                            callback.callback((Object)true);
                            return;
                        }
                        ConstraintValueEditorHelper.this.oracle.getSuperTypes(boundClassName, (Callback)new Callback<List<String>>(){

                            public void callback(List<String> superTypes) {
                                callback.callback((Object)ConstraintValueEditorHelper.this.checkSuperTypes(superTypes));
                            }
                        });
                    } else {
                        callback.callback((Object)false);
                    }
                }
            }
        });
    }

    private void isBoundVariableApplicableByFactType(String boundVariable, Callback<Boolean> callback) {
        FactPattern lhsBoundFact = this.model.getLHSBoundFact(boundVariable);
        if (lhsBoundFact != null) {
            String boundFactType = lhsBoundFact.getFactType();
            String factCollectionType = this.oracle.getParametricFieldType(this.factType, this.fieldName);
            if (boundFactType != null && factCollectionType != null && boundFactType.equals(factCollectionType)) {
                callback.callback((Object)true);
                return;
            }
        }
        callback.callback((Object)false);
    }

    private void isBoundVariableApplicableByFieldType(String boundFieldType, final Callback<Boolean> callback) {
        String factCollectionType;
        if (this.fieldName.equals("this")) {
            this.oracle.isFactTypeAnEvent(boundFieldType, (Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (!Boolean.TRUE.equals(result)) {
                        callback.callback((Object)false);
                        return;
                    }
                    ConstraintValueEditorHelper.this.oracle.isFactTypeAnEvent(ConstraintValueEditorHelper.this.fieldType, (Callback)new Callback<Boolean>(){

                        public void callback(Boolean result) {
                            if (Boolean.TRUE.equals(result)) {
                                if (CEPOracle.isCEPOperator((String)ConstraintValueEditorHelper.this.constraint.getOperator())) {
                                    callback.callback((Object)true);
                                    return;
                                }
                            } else {
                                callback.callback((Object)false);
                                return;
                            }
                        }
                    });
                }
            });
        }
        if (this.fieldName.equals("this") && boundFieldType.equals("Date") && CEPOracle.isCEPOperator((String)this.constraint.getOperator())) {
            callback.callback((Object)true);
            return;
        }
        if (this.fieldType.equals("Date")) {
            this.oracle.isFactTypeAnEvent(boundFieldType, (Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.TRUE.equals(result) && CEPOracle.isCEPOperator((String)ConstraintValueEditorHelper.this.constraint.getOperator())) {
                        callback.callback((Object)true);
                        return;
                    }
                }
            });
        }
        if ((factCollectionType = this.oracle.getParametricFieldType(this.factType, this.fieldName)) != null && factCollectionType.equals(boundFieldType)) {
            callback.callback((Object)true);
            return;
        }
        callback.callback((Object)false);
    }

    private void isLHSFieldTypeEquivalent(String boundVariable, Callback<Boolean> callback) {
        String boundFieldType = this.model.getLHSBindingType(boundVariable);
        if (boundFieldType.equals("Comparable")) {
            if (!this.fieldType.equals("Comparable")) {
                callback.callback((Object)false);
                return;
            }
            SingleFieldConstraint fc = this.model.getLHSBoundField(boundVariable);
            String fieldName = fc.getFieldName();
            String parentFactTypeForBinding = this.model.getLHSParentFactPatternForBinding(boundVariable).getFactType();
            String[] dd = this.oracle.getEnumValues(parentFactTypeForBinding, fieldName);
            callback.callback((Object)ConstraintValueEditorHelper.isEnumEquivalent(dd, this.dropDownData));
            return;
        }
        this.isBoundVariableApplicableByFieldType(boundFieldType, callback);
    }

    public static boolean isEnumEquivalent(String[] values, DropDownData dropDownData) {
        return Arrays.equals(values, dropDownData.getFixedList());
    }

    private void isLHSFactTypeEquivalent(String boundVariable, Callback<Boolean> callback) {
        FactPattern factPattern = this.model.getLHSBoundFact(boundVariable);
        if (factPattern == null) {
            callback.callback((Object)false);
            return;
        }
        String boundFactType = factPattern.getFactType();
        String fieldType = this.getFieldTypeClazz();
        if (fieldType.equals(boundFactType)) {
            callback.callback((Object)true);
            return;
        }
        this.isLHSFactTypeAnEvent(boundVariable, boundFactType, fieldType, callback);
    }

    private void isLHSFactTypeAnEvent(final String boundVariable, final String boundFactType, final String fieldType, final Callback<Boolean> callback) {
        this.oracle.isFactTypeAnEvent(boundFactType, (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (Boolean.TRUE.equals(result)) {
                    ConstraintValueEditorHelper.this.oracle.isFactTypeAnEvent(fieldType, (Callback)new Callback<Boolean>(){

                        public void callback(Boolean result) {
                            if (Boolean.TRUE.equals(result)) {
                                if (CEPOracle.isCEPOperator((String)ConstraintValueEditorHelper.this.constraint.getOperator())) {
                                    callback.callback((Object)true);
                                    return;
                                }
                                ConstraintValueEditorHelper.this.isLHSFactTypeAssignable(boundVariable, boundFactType, (Callback<Boolean>)callback);
                            } else {
                                ConstraintValueEditorHelper.this.isLHSFactTypeAssignable(boundVariable, boundFactType, (Callback<Boolean>)callback);
                            }
                        }
                    });
                } else {
                    ConstraintValueEditorHelper.this.isLHSFactTypeAssignable(boundVariable, boundFactType, (Callback<Boolean>)callback);
                }
            }
        });
    }

    private void isLHSFactTypeAssignable(final String boundVariable, String boundFactType, final Callback<Boolean> callback) {
        if (boundFactType.equals("Comparable")) {
            if (!this.fieldType.equals("Comparable")) {
                callback.callback((Object)false);
                return;
            }
            String[] dd = this.oracle.getEnumValues(boundFactType, this.fieldName);
            callback.callback((Object)ConstraintValueEditorHelper.isEnumEquivalent(dd, this.dropDownData));
        } else {
            this.oracle.getSuperTypes(boundFactType, (Callback)new Callback<List<String>>(){

                public void callback(List<String> superTypes) {
                    if (ConstraintValueEditorHelper.this.checkSuperTypes(superTypes)) {
                        callback.callback((Object)true);
                        return;
                    }
                    ConstraintValueEditorHelper.this.isBoundVariableApplicable(boundVariable, (Callback<Boolean>)callback);
                }
            });
        }
    }

    private boolean checkSuperTypes(List<String> superTypes) {
        if (superTypes != null) {
            for (String superType : superTypes) {
                if (!this.getFieldTypeClazz().equals(superType)) continue;
                return true;
            }
        }
        return false;
    }

    private String getFieldTypeClazz() {
        String fieldClassName = this.oracle.getFieldClassName(this.factType, this.fieldName);
        return fieldClassName;
    }
}

