/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.server.indexing;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelXMLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.server.indexing.GuidedRuleTemplateIndexVisitor;
import org.drools.workbench.screens.guided.template.type.GuidedRuleTemplateResourceTypeDefinition;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.metadata.engine.Indexer;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;

@ApplicationScoped
public class GuidedRuleTemplateFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(GuidedRuleTemplateFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected GuidedRuleTemplateResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String content = this.ioService.readAllString(path);
            TemplateModel model = RuleTemplateModelXMLPersistenceImpl.getInstance().unmarshal(content);
            DefaultIndexBuilder builder = new DefaultIndexBuilder();
            GuidedRuleTemplateIndexVisitor visitor = new GuidedRuleTemplateIndexVisitor(builder, model);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }
}

