/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelDRLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.service.GuidedRuleTemplateEditorService;
import org.drools.workbench.screens.guided.template.type.GuidedRuleTemplateResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.source.BaseSourceService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedRuleTemplateSourceService
extends BaseSourceService<TemplateModel> {
    private static final Logger logger = LoggerFactory.getLogger(GuidedRuleTemplateSourceService.class);
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    @Inject
    private GuidedRuleTemplateResourceTypeDefinition resourceType;
    @Inject
    private GuidedRuleTemplateEditorService guidedRuleTemplateEditorService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private KieProjectService projectService;

    public String getPattern() {
        return this.resourceType.getSuffix();
    }

    public String getSource(Path path, TemplateModel model) {
        if (model == null) {
            return "";
        }
        String dslr = RuleTemplateModelDRLPersistenceImpl.getInstance().marshal((RuleModel)model);
        Expander expander = this.getDSLExpander(path);
        String drl = expander.expand(dslr);
        return drl;
    }

    public String getSource(Path path) {
        return this.getSource(path, (TemplateModel)this.guidedRuleTemplateEditorService.load(Paths.convert((Path)path)));
    }

    private Expander getDSLExpander(Path path) {
        DefaultExpander expander = new DefaultExpander();
        List<DSLMappingFile> dsls = this.getDSLMappingFiles(path);
        for (DSLMappingFile dsl : dsls) {
            expander.addDSLMapping(dsl.getMapping());
        }
        return expander;
    }

    private List<DSLMappingFile> getDSLMappingFiles(Path path) {
        ArrayList<DSLMappingFile> dsls = new ArrayList<DSLMappingFile>();
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(vfsPath).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            DSLTokenizedMappingFile dslFile = new DSLTokenizedMappingFile();
            try {
                if (dslFile.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                    dsls.add((DSLMappingFile)dslFile);
                    continue;
                }
                logger.error("Unable to parse DSL definition: " + dslDefinition);
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
        }
        return dsls;
    }
}

