/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.util;

import java.util.ArrayList;
import java.util.List;

public class ExportUtils {
    private static final String[] JAVA_KEYWORDS = new String[]{"package", "import", "class", "public", "protected", "private", "extends", "implements", "return", "if", "while", "for", "do", "else", "try", "new", "void", "catch", "throws", "throw", "static", "final", "break", "continue", "super", "finally", "true", "false", "true;", "false;", "null", "boolean", "int", "char", "long", "float", "double", "short", "abstract", "this", "switch", "assert", "default", "goto", "synchronized", "byte", "case", "enum", "instanceof", "transient", "interface", "strictfp", "volatile", "const", "native"};
    private static final String KEYWORD = "global ";

    public String normalizePackageName(String stringToEscape) {
        String[] nameSplit = stringToEscape.split("\\.");
        StringBuilder normalizedPkgNameBuilder = new StringBuilder();
        for (int j = 0; j < nameSplit.length; ++j) {
            int i = 0;
            if (j > 0 && j < nameSplit.length) {
                normalizedPkgNameBuilder.append(".");
            }
            while (i < JAVA_KEYWORDS.length) {
                if (JAVA_KEYWORDS[i].equals(nameSplit[j])) {
                    normalizedPkgNameBuilder.append("mod_");
                    normalizedPkgNameBuilder.append(nameSplit[j].toLowerCase());
                    break;
                }
                ++i;
            }
            if (i != JAVA_KEYWORDS.length) continue;
            normalizedPkgNameBuilder.append(nameSplit[j].toLowerCase());
        }
        return normalizedPkgNameBuilder.toString();
    }

    public static List<String> parseGlobals(String content) {
        ArrayList<String> globals = new ArrayList<String>();
        if (content == null || content.trim().equals("")) {
            return globals;
        }
        String[] lines = content.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.equals("") || line.startsWith("#") || !line.startsWith(KEYWORD)) continue;
            if ((line = line.substring(KEYWORD.length()).trim()).endsWith(";")) {
                line = line.substring(0, line.length() - 1);
            }
            globals.add(line);
        }
        return globals;
    }

    public static String migrateStartOfCommentChar(String source) {
        boolean isSingleQuoted = false;
        boolean isDoubleQuoted = false;
        StringBuilder sbResult = new StringBuilder();
        block5: for (int charIndex = 0; charIndex < source.length(); ++charIndex) {
            char currentChar = source.charAt(charIndex);
            switch (currentChar) {
                case '\'': {
                    boolean isSingleQuoteEscaped;
                    boolean bl = isSingleQuoteEscaped = charIndex > 0 && source.charAt(charIndex - 1) == '\\';
                    if (!isSingleQuoteEscaped) {
                        isSingleQuoted = isDoubleQuoted ? false : !isSingleQuoted;
                    }
                    sbResult.append(currentChar);
                    continue block5;
                }
                case '\"': {
                    boolean isDoubleQuoteEscaped;
                    boolean bl = isDoubleQuoteEscaped = charIndex > 0 && source.charAt(charIndex - 1) == '\\';
                    if (!isDoubleQuoteEscaped) {
                        isDoubleQuoted = isSingleQuoted ? false : !isDoubleQuoted;
                    }
                    sbResult.append(currentChar);
                    continue block5;
                }
                case '#': {
                    boolean isDslDebugChar;
                    boolean bl = isDslDebugChar = charIndex + 1 <= source.length() - 1 && source.charAt(charIndex + 1) == '/';
                    if (isSingleQuoted || isDoubleQuoted || isDslDebugChar) {
                        sbResult.append(currentChar);
                        continue block5;
                    }
                    sbResult.append("//");
                    continue block5;
                }
                default: {
                    sbResult.append(currentChar);
                }
            }
        }
        return sbResult.toString();
    }
}

