/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;

@ApplicationScoped
public class VfrImportConfig {
    private static String DEFAULT_MIGRATION_FILE_SYSTEM = "guvnor-jcr2vfs-migration";
    public static final String formatstr = "runMigration  [options...]";
    private File importTempDir;
    private File outputVfsRepository;
    private boolean forceOverwriteOutputVfsRepository;
    private String outputRepoName;

    public File getImportTempDir() {
        return this.importTempDir;
    }

    public File getOutputVfsRepository() {
        return this.outputVfsRepository;
    }

    public String getOutputRepoName() {
        return this.outputRepoName;
    }

    public boolean parseArgs(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("h", "help", false, "help for the command.");
        options.addOption("i", "importTempDir", true, "The temporary import directory");
        options.addOption("o", "outputVfsRepository", true, "The Guvnor 6 VFS repository");
        options.addOption("r", "repoName", true, "The Guvnor 6 VFS Repository name");
        options.addOption("f", "forceOverwriteOutputVfsRepository", false, "Force overwriting the Guvnor 6 VFS repository");
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = new BasicParser().parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(formatstr, options);
            return false;
        }
        if (commandLine.hasOption("h")) {
            formatter.printHelp(formatstr, options);
            return false;
        }
        return this.parseArgInputTempDir(commandLine) && this.parseArgOutputVfsRepository(commandLine);
    }

    private boolean parseArgInputTempDir(CommandLine commandLine) {
        this.importTempDir = new File(commandLine.getOptionValue("i", "./jcrExport"));
        try {
            if (this.importTempDir.isFile()) {
                System.out.println("The export directory specified (" + this.importTempDir.getAbsolutePath() + ") is not a directory.");
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("The export directory (" + this.importTempDir + ") has issues: " + e);
            return false;
        }
        return true;
    }

    private boolean parseArgOutputVfsRepository(CommandLine commandLine) {
        this.outputRepoName = commandLine.getOptionValue("r", DEFAULT_MIGRATION_FILE_SYSTEM);
        this.outputVfsRepository = new File(commandLine.getOptionValue("o", "outputVfs"));
        this.forceOverwriteOutputVfsRepository = commandLine.hasOption("f");
        if (this.outputVfsRepository.exists()) {
            if (this.forceOverwriteOutputVfsRepository) {
                try {
                    FileUtils.deleteDirectory((File)this.outputVfsRepository);
                }
                catch (IOException e) {
                    System.out.println("Force deleting outputVfsRepository (" + this.outputVfsRepository.getAbsolutePath() + ") failed: " + e);
                    return false;
                }
            } else {
                System.out.println("The outputVfsRepository (" + this.outputVfsRepository.getAbsolutePath() + ") already exists.");
                return false;
            }
        }
        try {
            this.outputVfsRepository = this.outputVfsRepository.getCanonicalFile();
            FileUtils.forceMkdir((File)this.outputVfsRepository);
        }
        catch (IOException e) {
            System.out.println("The outputVfsRepository (" + this.outputVfsRepository + ") has issues: " + e);
            return false;
        }
        return true;
    }
}

