/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.config.VfsImportConfig;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.CategoryImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.ModuleAssetImporter;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;

@ApplicationScoped
public class VfsImporter {
    @Inject
    protected VfsImportConfig vfsImportConfig;
    @Inject
    FileManager fileManager;
    @Inject
    protected CategoryImporter categoryImporter;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    protected ModuleAssetImporter moduleAssetImporter;
    @Inject
    protected BoundSessionContext sessionContext;
    protected Map<String, Object> sessionDataStore;
    @Inject
    protected BoundRequestContext requestContext;
    protected Map<String, Object> requestDataStore;

    public boolean parseArgs(String[] args) {
        boolean ok = this.vfsImportConfig.parseArgs(args);
        if (ok) {
            this.fileManager.setExportTempDir(this.vfsImportConfig.getImportTempDir());
        }
        return ok;
    }

    public void importAll() {
        System.out.format("Jcr import started. Reading from import directory ({%s}).%n", this.vfsImportConfig.getImportTempDir().getAbsolutePath());
        try {
            this.migrationPathManager.setRepoName(this.vfsImportConfig.getOutputRepoName(), this.vfsImportConfig.getOutputVfsRepository().getCanonicalPath());
            this.startContexts();
            this.categoryImporter.importAll();
            this.moduleAssetImporter.importAll();
            this.endContexts();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void startContexts() {
        this.sessionDataStore = new HashMap<String, Object>();
        this.sessionContext.associate(this.sessionDataStore);
        this.sessionContext.activate();
        this.requestDataStore = new HashMap<String, Object>();
        this.requestContext.associate(this.requestDataStore);
        this.requestContext.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endContexts() {
        try {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
        finally {
            this.requestContext.dissociate(this.requestDataStore);
        }
        try {
            this.sessionContext.invalidate();
            this.sessionContext.deactivate();
        }
        finally {
            this.sessionContext.dissociate(this.sessionDataStore);
        }
    }
}

