/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport.asset;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.AssetImporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.StandardCopyOption;

public class FactModelImporter
implements AssetImporter<DataModelAsset> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MigrationPathManager migrationPathManager;
    @Inject
    private ProjectService<KieProject> projectService;
    @Inject
    private DataModelerService modelerService;
    private Map<String, String> orderedBaseTypes = new TreeMap<String, String>();
    private Map<String, AnnotationDefinition> annotationDefinitions;

    @Override
    public Path importAsset(Module xmlModule, DataModelAsset xmlAsset, Path previousVersionPath) {
        String normalizedPackageName = xmlModule.getNormalizedPackageName();
        Path path = this.migrationPathManager.generatePathForAsset(xmlModule, (XmlAsset)xmlAsset, xmlAsset.getAssetType().toString());
        if (previousVersionPath != null && !previousVersionPath.equals(path)) {
            this.ioService.move(Paths.convert((Path)previousVersionPath), Paths.convert((Path)path), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        this.initBasePropertyTypes();
        this.initAnnotationDefinitions();
        if (project == null) {
            Path projectRootPath = this.migrationPathManager.generatePathForModule(normalizedPackageName);
            project = new KieProject(projectRootPath, projectRootPath, projectRootPath, projectRootPath, projectRootPath, "");
        }
        DataModelImpl dataModel = new DataModelImpl();
        Iterator objIt = xmlAsset.modelObjects();
        while (objIt.hasNext()) {
            DataModelAsset.DataModelObject obj = (DataModelAsset.DataModelObject)objIt.next();
            DataObjectImpl dataObject = new DataObjectImpl(obj.getName(), normalizedPackageName);
            dataObject.setSuperClassName(obj.getSuperType());
            Iterator propIt = obj.properties();
            while (propIt.hasNext()) {
                DataModelAsset.DataObjectProperty objProp = (DataModelAsset.DataObjectProperty)propIt.next();
                String fieldName = objProp.getName();
                String fieldType = objProp.getType();
                boolean isMultiple = false;
                boolean isBaseType = this.isBaseType(fieldType);
                ObjectPropertyImpl property = new ObjectPropertyImpl(fieldName, fieldType, isMultiple);
                property.setBaseType(isBaseType);
                dataObject.addProperty((ObjectProperty)property);
            }
            Iterator annIt = obj.annotations();
            while (annIt.hasNext()) {
                DataModelAsset.DataObjectAnnotation objAnn = (DataModelAsset.DataObjectAnnotation)annIt.next();
                String name = objAnn.getName();
                String key = objAnn.getKey();
                String value = objAnn.getValue();
                if (!"Role".equals(name)) continue;
                AnnotationImpl annotation = new AnnotationImpl(this.annotationDefinitions.get("org.kie.api.definition.type.Role"));
                annotation.setValue(key, (Object)value);
            }
            dataModel.addDataObject((DataObject)dataObject);
        }
        this.modelerService.saveModel((DataModel)dataModel, project);
        return path;
    }

    private void initBasePropertyTypes() {
        List baseTypes = this.modelerService.getBasePropertyTypes();
        if (baseTypes != null) {
            for (PropertyType type : baseTypes) {
                this.orderedBaseTypes.put(type.getName(), type.getClassName());
            }
        }
    }

    private void initAnnotationDefinitions() {
        this.annotationDefinitions = this.modelerService.getAnnotationDefinitions();
    }

    private Boolean isBaseType(String type) {
        return this.orderedBaseTypes.containsValue(type);
    }
}

