/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VfsImportConfig {
    private static final Logger logger = LoggerFactory.getLogger(VfsImportConfig.class);
    private static final String DEFAULT_MIGRATION_FILE_SYSTEM = "guvnor-jcr2vfs-migration";
    private static final String FORMAT_STR = "runMigration  [options...]";
    private File importTempDir;
    private File outputVfsRepository;
    private String outputRepoName;

    public File getImportTempDir() {
        return this.importTempDir;
    }

    public File getOutputVfsRepository() {
        return this.outputVfsRepository;
    }

    public String getOutputRepoName() {
        return this.outputRepoName;
    }

    public boolean parseArgs(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("h", "help", false, "help for the command.");
        options.addOption("i", "importTempDir", true, "The temporary import directory");
        options.addOption("o", "outputVfsRepository", true, "The Guvnor 6 VFS repository");
        options.addOption("r", "repoName", true, "The Guvnor 6 VFS Repository name");
        options.addOption("f", "forceOverwriteOutputVfsRepository", false, "Force overwriting the Guvnor 6 VFS repository");
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = new BasicParser().parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(FORMAT_STR, options);
            return false;
        }
        if (commandLine.hasOption("h")) {
            formatter.printHelp(FORMAT_STR, options);
            return false;
        }
        return this.parseArgInputTempDir(commandLine) && this.parseArgOutputVfsRepository(commandLine);
    }

    private boolean parseArgInputTempDir(CommandLine commandLine) {
        this.importTempDir = new File(commandLine.getOptionValue("i", "./jcrExport"));
        try {
            if (this.importTempDir.isFile()) {
                logger.error("The specified export directory specified ({}) is not a directory!", (Object)this.importTempDir.getAbsolutePath());
                return false;
            }
        }
        catch (Exception e) {
            logger.error("The specified export directory ({}) has issues!", (Object)this.importTempDir, (Object)e);
            return false;
        }
        return true;
    }

    private boolean parseArgOutputVfsRepository(CommandLine commandLine) {
        this.outputRepoName = commandLine.getOptionValue("r", DEFAULT_MIGRATION_FILE_SYSTEM);
        this.outputVfsRepository = new File(commandLine.getOptionValue("o", "outputVfs"));
        boolean forceOverwriteOutputVfsRepository = commandLine.hasOption("f");
        if (this.outputVfsRepository.exists()) {
            if (forceOverwriteOutputVfsRepository) {
                try {
                    FileUtils.deleteDirectory((File)this.outputVfsRepository);
                }
                catch (IOException e) {
                    logger.error("Force deleting outputVfsRepository ({}) failed!", (Object)this.outputVfsRepository.getAbsolutePath(), (Object)e);
                    return false;
                }
            } else {
                logger.error("The outputVfsRepository ({}) already exists!", (Object)this.outputVfsRepository.getAbsolutePath());
                return false;
            }
        }
        try {
            this.outputVfsRepository = this.outputVfsRepository.getCanonicalFile();
            FileUtils.forceMkdir((File)this.outputVfsRepository);
        }
        catch (IOException e) {
            logger.error("The outputVfsRepository ({}) has issues!", (Object)this.outputVfsRepository, (Object)e);
            return false;
        }
        return true;
    }
}

