/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.util;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.drools.workbench.models.commons.backend.imports.ImportsParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameWriter;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.packages.HasPackageName;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.EncodingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PackageImportHelper {
    @Inject
    private ProjectService projectService;

    public String assertPackageNameXML(String xml, Path resource) {
        Package pkg = this.projectService.resolvePackage(resource);
        String pkName = null;
        try {
            pkName = pkg.getPackageName();
            if (pkName != null && pkg.getPackageName().endsWith(EncodingUtil.decode((String)resource.getFileName()))) {
                pkName = pkg.getPackageName().substring(0, pkg.getPackageName().indexOf(EncodingUtil.decode((String)resource.getFileName())) - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String requiredPackageName = pkName;
        if (requiredPackageName == null || "".equals(requiredPackageName)) {
            return xml;
        }
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            Document doc = dombuilder.parse(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
            if (doc.getElementsByTagName("packageName").getLength() != 0) {
                return xml;
            }
            Element root = doc.getDocumentElement();
            Element packageElement = doc.createElement("packageName");
            packageElement.appendChild(doc.createTextNode(requiredPackageName));
            root.appendChild(packageElement);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource s = new DOMSource(root);
            trans.transform(s, result);
            String xmlString = sw.toString();
            if (xmlString != null) {
                xmlString = xmlString.substring(xmlString.indexOf(">") + 1);
            }
            return xmlString;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public String assertPackageImportDRL(String drl, String packageHeader, Path resource) {
        if (packageHeader == null) {
            return drl;
        }
        Imports imports = ImportsParser.parseImports((String)packageHeader);
        if (imports == null || drl.toLowerCase().indexOf("import ") != -1) {
            return drl;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(imports.toString());
        if (imports.getImports().size() > 0) {
            sb.append("\n");
        }
        sb.append(drl);
        return sb.toString();
    }

    public String assertPackageImportXML(String xml, String packageHeader, Path resource) {
        if (packageHeader == null) {
            return xml;
        }
        Imports imports = ImportsParser.parseImports((String)packageHeader);
        if (imports == null) {
            return xml;
        }
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            Document doc = dombuilder.parse(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
            if (doc.getElementsByTagName("imports").getLength() != 0) {
                return xml;
            }
            Element root = doc.getDocumentElement();
            Element topImportsElement = doc.createElement("imports");
            Element nestedImportsElement = doc.createElement("imports");
            topImportsElement.appendChild(nestedImportsElement);
            for (Import i : imports.getImports()) {
                Element importElement = doc.createElement(Import.class.getCanonicalName());
                Element typeElement = doc.createElement("type");
                typeElement.appendChild(doc.createTextNode(i.getType()));
                importElement.appendChild(typeElement);
                nestedImportsElement.appendChild(importElement);
            }
            root.appendChild(topImportsElement);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource s = new DOMSource(root);
            trans.transform(s, result);
            String xmlString = sw.toString();
            if (xmlString != null) {
                xmlString = xmlString.substring(xmlString.indexOf(">") + 1);
            }
            return xmlString;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public String assertPackageName(String drl, Path resource) {
        try {
            String existingPackageName = PackageNameParser.parsePackageName((String)drl);
            if (!"".equals(existingPackageName)) {
                return drl;
            }
            Package pkg = this.projectService.resolvePackage(resource);
            String pkName = null;
            try {
                pkName = pkg.getPackageName();
                if (pkName != null && pkg.getPackageName().endsWith(EncodingUtil.decode((String)resource.getFileName()))) {
                    pkName = pkg.getPackageName().substring(0, pkg.getPackageName().indexOf(EncodingUtil.decode((String)resource.getFileName())) - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            final String requiredPackageName = pkName;
            HasPackageName mockHasPackageName = new HasPackageName(){

                public String getPackageName() {
                    return requiredPackageName;
                }

                public void setPackageName(String packageName) {
                }
            };
            StringBuilder sb = new StringBuilder();
            PackageNameWriter.write((StringBuilder)sb, (HasPackageName)mockHasPackageName);
            sb.append(drl);
            return sb.toString();
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

