/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport.asset;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.util.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.util.TestScenarioXMLElementMigrater;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.AssetImporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.PlainTextAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;

public class TestScenarioImporter
implements AssetImporter<PlainTextAsset> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    PackageImportHelper packageImportHelper;

    @Override
    public org.uberfire.backend.vfs.Path importAsset(Module xmlModule, PlainTextAsset xmlAsset, org.uberfire.backend.vfs.Path previousVersionPath) {
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForAsset(xmlModule, (XmlAsset)xmlAsset, xmlAsset.getAssetType().toString());
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (previousVersionPath != null && !previousVersionPath.equals(path)) {
            this.ioService.move(Paths.convert((org.uberfire.backend.vfs.Path)previousVersionPath), nioPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        String packageHeader = xmlModule.getPackageHeaderInfo();
        String content = xmlAsset.getContent();
        content = TestScenarioXMLElementMigrater.migrate(content);
        String sourceContentWithPackage = this.packageImportHelper.assertPackageNameXML(content, path);
        sourceContentWithPackage = this.packageImportHelper.assertPackageImportXML(sourceContentWithPackage, packageHeader, path);
        this.ioService.write(nioPath, sourceContentWithPackage, (Map)null, new OpenOption[]{new CommentedOption(xmlAsset.getLastContributor(), null, xmlAsset.getCheckinComment(), xmlAsset.getLastModified())});
        return path;
    }
}

