/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataModelAssetFormat
extends XmlAssetFormat {
    private static final String MODEL_OBJ = "modelObject";
    private static final String MODEL_OBJ_NAME = "objName";
    private static final String MODEL_OBJ_SUPERTYPE = "objSuperType";
    private static final String MODEL_OBJ_PROP = "objProperty";
    private static final String MODEL_OBJ_PROP_NAME = "objPropName";
    private static final String MODEL_OBJ_PROP_TYPE = "objPropType";
    private static final String MODEL_OBJ_ANN = "objAnnotation";
    private static final String MODEL_OBJ_ANN_NAME = "objAnnName";
    private static final String MODEL_OBJ_ANN_KEY = "objAnnKey";
    private static final String MODEL_OBJ_ANN_VALUE = "objAnnValue";

    protected String doFormat(DataModelAsset dataModelAsset) {
        StringBuilder sb = new StringBuilder();
        Iterator<DataModelAsset.DataModelObject> objectIt = dataModelAsset.modelObjects();
        while (objectIt.hasNext()) {
            DataModelAsset.DataModelObject obj = objectIt.next();
            String objSuperType = StringUtils.isNotBlank((CharSequence)obj.getSuperType()) ? obj.getSuperType() : "";
            sb.append("<").append(MODEL_OBJ).append(" ").append(MODEL_OBJ_NAME).append("=\"").append(obj.getName()).append("\"").append(" ").append(MODEL_OBJ_SUPERTYPE).append("=\"").append(objSuperType).append("\"").append(">");
            Iterator<DataModelAsset.DataObjectProperty> propIt = obj.properties();
            while (propIt.hasNext()) {
                DataModelAsset.DataObjectProperty prop = propIt.next();
                sb.append("<").append(MODEL_OBJ_PROP).append(" ").append(MODEL_OBJ_PROP_NAME).append("=\"").append(prop.getName()).append("\"").append(" ").append(MODEL_OBJ_PROP_TYPE).append("=\"").append(prop.getType()).append("\"").append("/>");
            }
            Iterator<DataModelAsset.DataObjectAnnotation> annIt = obj.annotations();
            while (annIt.hasNext()) {
                DataModelAsset.DataObjectAnnotation ann = annIt.next();
                sb.append("<").append(MODEL_OBJ_ANN).append(" ").append(MODEL_OBJ_ANN_NAME).append("=\"").append(ann.getName()).append("\"").append(" ").append(MODEL_OBJ_ANN_KEY).append("=\"").append(ann.getKey()).append("\"").append(" ").append(MODEL_OBJ_ANN_VALUE).append("=\"").append(ann.getValue()).append("\"").append("/>");
            }
            sb.append("</").append(MODEL_OBJ).append(">");
        }
        return sb.toString();
    }

    protected DataModelAsset doParse(String name, String format, String lastContributor, String checkinComment, Date lastModified, Node assetNode) {
        DataModelAsset dataModel = new DataModelAsset(name, format, lastContributor, checkinComment, lastModified);
        NodeList modelNodeList = assetNode.getChildNodes();
        for (int i = 0; i < modelNodeList.getLength(); ++i) {
            Node objNode = modelNodeList.item(i);
            if (!MODEL_OBJ.equalsIgnoreCase(objNode.getNodeName())) continue;
            NamedNodeMap objAttribs = objNode.getAttributes();
            String objName = objAttribs.getNamedItem(MODEL_OBJ_NAME).getNodeValue();
            String objSuperType = objAttribs.getNamedItem(MODEL_OBJ_SUPERTYPE).getNodeValue();
            DataModelAsset.DataModelObject obj = dataModel.addDataModelObject(objName, objSuperType);
            NodeList objNodeList = objNode.getChildNodes();
            for (int j = 0; j < objNodeList.getLength(); ++j) {
                Node objChildNode = objNodeList.item(j);
                NamedNodeMap childNodeAttribs = objChildNode.getAttributes();
                if (MODEL_OBJ_PROP.equalsIgnoreCase(objChildNode.getNodeName())) {
                    obj.addObjectProperty(childNodeAttribs.getNamedItem(MODEL_OBJ_PROP_NAME).getNodeValue(), childNodeAttribs.getNamedItem(MODEL_OBJ_PROP_TYPE).getNodeValue());
                    continue;
                }
                if (!MODEL_OBJ_ANN.equalsIgnoreCase(objChildNode.getNodeName())) continue;
                obj.addObjectAnnotation(childNodeAttribs.getNamedItem(MODEL_OBJ_ANN_NAME).getNodeValue(), childNodeAttribs.getNamedItem(MODEL_OBJ_ANN_KEY).getNodeValue(), childNodeAttribs.getNamedItem(MODEL_OBJ_ANN_VALUE).getNodeValue());
            }
        }
        return dataModel;
    }
}

