/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetsFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.AssetType;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAssets;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlAssetFormat
implements XmlFormat<XmlAsset> {
    protected static final String ASSET = "asset";
    protected static final String ASSET_NAME = "name";
    protected static final String ASSET_TYPE = "type";
    protected static final String ASSET_LAST_CONTRIBUTOR = "lastContrib";
    protected static final String ASSET_LAST_MODIFIED = "lastModif";
    protected static final String ASSET_CHECKIN_COMMENT = "comment";
    protected static final String ASSET_HISTORY = "history";
    private XmlAssetsFormat xmlAssetsFormat;

    @Override
    public void format(StringBuilder sb, XmlAsset xmlAsset) {
        if (sb == null || xmlAsset == null) {
            throw new IllegalArgumentException("No output or asset specified");
        }
        if (AssetType.IGNORED.equals((Object)xmlAsset.getAssetType())) {
            return;
        }
        this.initialize();
        this.formatAssetStart(sb, xmlAsset);
        sb.append(this.formatAssetAsString(xmlAsset));
        this.formatAssetEnd(sb, xmlAsset);
    }

    @Override
    public XmlAsset parse(Node assetNode) {
        if (assetNode == null || !ASSET.equals(assetNode.getNodeName())) {
            throw new IllegalArgumentException("No input asset node specified for parsing");
        }
        this.initialize();
        XmlGenericAttributes genericAttributes = this.parseGenericNodeContent(assetNode);
        XmlAsset xmlAsset = this.parseStringToXmlAsset(genericAttributes.getAssetName(), genericAttributes.getAssetFormat(), genericAttributes.getAssetLastContributor(), genericAttributes.getAssetCheckinComment(), genericAttributes.getAssetLastModified(), assetNode);
        xmlAsset.setAssetHistory(this.parseAssetHistory(assetNode));
        return xmlAsset;
    }

    protected abstract String formatAssetAsString(XmlAsset var1);

    protected abstract XmlAsset parseStringToXmlAsset(String var1, String var2, String var3, String var4, Date var5, Node var6);

    protected XmlAssets parseAssetHistory(Node assetNode) {
        NodeList assetNodeChildren = assetNode.getChildNodes();
        for (int i = 0; i < assetNodeChildren.getLength(); ++i) {
            Node node = assetNodeChildren.item(i);
            if (!ASSET_HISTORY.equals(node.getNodeName())) continue;
            return this.xmlAssetsFormat.parse(node.getFirstChild());
        }
        return new XmlAssets();
    }

    private void formatAssetStart(StringBuilder sb, XmlAsset xmlAsset) {
        String lastContributor = StringUtils.isNotBlank((CharSequence)xmlAsset.getLastContributor()) ? xmlAsset.getLastContributor() : "--";
        Date lastModified = xmlAsset.getLastModified() != null ? xmlAsset.getLastModified() : new Date();
        sb.append("<").append(ASSET).append(" ").append(ASSET_NAME).append("=\"").append(xmlAsset.getName()).append("\"").append(" ").append(ASSET_TYPE).append("=\"").append(xmlAsset.getAssetType().toString()).append("\"").append(" ").append(ASSET_LAST_CONTRIBUTOR).append("=\"").append(lastContributor).append("\"").append(" ").append(ASSET_LAST_MODIFIED).append("=\"").append(lastModified.getTime()).append("\"").append(">");
        sb.append("<").append(ASSET_CHECKIN_COMMENT).append(">").append(ExportXmlUtils.formatCdataSection(xmlAsset.getCheckinComment())).append("</").append(ASSET_CHECKIN_COMMENT).append(">");
    }

    private void formatAssetEnd(StringBuilder sb, XmlAsset xmlAsset) {
        if (xmlAsset.getAssetHistory() != null) {
            sb.append("<").append(ASSET_HISTORY).append(">");
            this.xmlAssetsFormat.format(sb, xmlAsset.getAssetHistory());
            sb.append("</").append(ASSET_HISTORY).append(">");
        }
        sb.append("</").append(ASSET).append(">");
    }

    private XmlGenericAttributes parseGenericNodeContent(Node assetNode) {
        NamedNodeMap assetAttribs = assetNode.getAttributes();
        Node commentNode = assetNode.getFirstChild();
        String checkinComment = ExportXmlUtils.parseCdataSection(commentNode);
        return new XmlGenericAttributes(assetAttribs.getNamedItem(ASSET_NAME).getNodeValue(), assetAttribs.getNamedItem(ASSET_TYPE).getNodeValue(), assetAttribs.getNamedItem(ASSET_LAST_CONTRIBUTOR).getNodeValue(), checkinComment, new Date(Long.parseLong(assetAttribs.getNamedItem(ASSET_LAST_MODIFIED).getNodeValue(), 10)));
    }

    private void initialize() {
        if (this.xmlAssetsFormat == null) {
            this.xmlAssetsFormat = new XmlAssetsFormat();
        }
    }

    private class XmlGenericAttributes {
        private String assetName;
        private String assetFormat;
        private String assetLastContributor;
        private String assetCheckinComment;
        private Date assetLastModified;

        private XmlGenericAttributes(String assetName, String assetFormat, String assetLastContributor, String assetCheckinComment, Date assetLastModified) {
            this.assetName = assetName;
            this.assetFormat = assetFormat;
            this.assetLastContributor = assetLastContributor;
            this.assetCheckinComment = assetCheckinComment;
            this.assetLastModified = assetLastModified;
        }

        private String getAssetName() {
            return this.assetName;
        }

        private String getAssetFormat() {
            return this.assetFormat;
        }

        private String getAssetLastContributor() {
            return this.assetLastContributor;
        }

        private String getAssetCheckinComment() {
            return this.assetCheckinComment;
        }

        private Date getAssetLastModified() {
            return this.assetLastModified;
        }
    }
}

