/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAssets;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlAssetsFormat
implements XmlFormat<XmlAssets> {
    public static final String ASSETS = "assets";
    private XmlAssetFormat xmlAssetFormat;

    @Override
    public void format(StringBuilder sb, XmlAssets xmlAssets) {
        if (sb == null || xmlAssets == null) {
            throw new IllegalArgumentException("No output or assets specified");
        }
        this.initialize();
        sb.append("<").append(ASSETS).append(">");
        Iterator<XmlAsset> it = xmlAssets.getAssets().iterator();
        while (it.hasNext()) {
            this.xmlAssetFormat.format(sb, it.next());
        }
        sb.append("</").append(ASSETS).append(">");
    }

    @Override
    public XmlAssets parse(Node assetsNode) {
        if (assetsNode == null || !ASSETS.equals(assetsNode.getNodeName())) {
            throw new IllegalArgumentException("No input assets node specified for parsing");
        }
        this.initialize();
        ArrayList<XmlAsset> assets = new ArrayList<XmlAsset>(10);
        NodeList assetNodes = assetsNode.getChildNodes();
        for (int i = 0; i < assetNodes.getLength(); ++i) {
            Node assetNode = assetNodes.item(i);
            if (assetNode == null) continue;
            XmlAsset xmlAsset = this.xmlAssetFormat.parse(assetNode);
            assets.add(xmlAsset);
        }
        return new XmlAssets(assets);
    }

    private void initialize() {
        if (this.xmlAssetFormat == null) {
            this.xmlAssetFormat = new XmlAssetFormat();
        }
    }
}

