/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.BusinessRuleAsset;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BusinessRuleAssetFormat
extends XmlAssetFormat {
    private static final String CONTENT = "content";
    private static final String HAS_DRL = "hasDrl";

    protected String doFormat(BusinessRuleAsset businessRuleAsset) {
        StringBuilder sb = new StringBuilder().append("<").append(CONTENT).append(">").append(ExportXmlUtils.formatCdataSection(businessRuleAsset.getContent())).append("</").append(CONTENT).append(">");
        sb.append("<").append(HAS_DRL).append(">").append(businessRuleAsset.hasDSLSentences() ? "true" : "false").append("</").append(HAS_DRL).append(">");
        return sb.toString();
    }

    protected BusinessRuleAsset doParse(String name, String format, String lastContributor, String checkinComment, Date lastModified, Node assetNode) {
        Boolean hasDSL = false;
        String content = null;
        NodeList assetNodeList = assetNode.getChildNodes();
        for (int i = 0; i < assetNodeList.getLength(); ++i) {
            Node node = assetNodeList.item(i);
            String nodeContent = node.getTextContent();
            if (CONTENT.equalsIgnoreCase(node.getNodeName())) {
                content = nodeContent;
                continue;
            }
            if (!HAS_DRL.equalsIgnoreCase(node.getNodeName())) continue;
            hasDSL = Boolean.valueOf(nodeContent);
        }
        return new BusinessRuleAsset(name, format, lastContributor, checkinComment, lastModified, content, hasDSL);
    }
}

