/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model.typedescriptor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Test;

public class FactModelTreeTest {
    private static final String FACT_NAME = "FactName";
    private static final String PACKAGE = "com";
    private static final String FACT_TYPE = "FactType";
    private static final String SIMPLE_PROPERTY_TYPE = "numeric";
    private static final String LIST_PROPERTY_TYPE = List.class.getCanonicalName();
    private static final String MAP_PROPERTY_TYPE = Map.class.getCanonicalName();
    private static final String IMPORT_PREFIX = "imp";

    @Test
    public void ofDMOConstructorNoTypeName() {
        FactModelTree factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)PACKAGE, Collections.emptyMap(), Collections.emptyMap(), null);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactName", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)0L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertFalse((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofDMOConstructorFactNameEqualsToTypeName() {
        FactModelTree factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)PACKAGE, Collections.emptyMap(), Collections.emptyMap(), (String)FACT_NAME);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactName", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)0L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertFalse((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofDMOConstructorFactNameNotEqualsToTypeName() {
        FactModelTree factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)PACKAGE, Collections.emptyMap(), Collections.emptyMap(), (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)0L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertFalse((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofSimpleDMO() {
        FactModelTree factModelTree = FactModelTree.ofSimpleDMO((String)FACT_NAME, (String)PACKAGE, (String)SIMPLE_PROPERTY_TYPE, (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)1L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((Object)SIMPLE_PROPERTY_TYPE, (Object)((FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertTrue((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofSimpleCollectionDMO() {
        FactModelTree factModelTree = FactModelTree.ofSimpleDMO((String)FACT_NAME, (String)PACKAGE, (String)LIST_PROPERTY_TYPE, (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)1L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((Object)LIST_PROPERTY_TYPE, (Object)((FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((long)1L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((long)1L, (long)((List)factModelTree.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)Object.class.getCanonicalName(), ((List)factModelTree.getGenericTypesMap().get("value")).get(0));
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertTrue((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofSimpleMapDMO() {
        FactModelTree factModelTree = FactModelTree.ofSimpleDMO((String)FACT_NAME, (String)PACKAGE, (String)MAP_PROPERTY_TYPE, (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)1L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((Object)MAP_PROPERTY_TYPE, (Object)((FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((long)1L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((long)2L, (long)((List)factModelTree.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)Object.class.getCanonicalName(), ((List)factModelTree.getGenericTypesMap().get("value")).get(0));
        Assert.assertEquals((Object)Object.class.getCanonicalName(), ((List)factModelTree.getGenericTypesMap().get("value")).get(1));
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
        Assert.assertTrue((boolean)factModelTree.isSimple());
        Assert.assertNull((Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofDMN() {
        FactModelTree factModelTree = FactModelTree.ofDMN((String)FACT_NAME, (String)IMPORT_PREFIX, Collections.emptyMap(), Collections.emptyMap(), (String)FACT_TYPE, (FactModelTree.Type)FactModelTree.Type.INPUT);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)"", (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)0L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.INPUT, (Object)factModelTree.getType());
        Assert.assertFalse((boolean)factModelTree.isSimple());
        Assert.assertEquals((Object)IMPORT_PREFIX, (Object)factModelTree.getImportPrefix());
    }

    @Test
    public void ofSimpleDMN() {
        FactModelTree factModelTree = FactModelTree.ofSimpleDMN((String)FACT_NAME, (String)IMPORT_PREFIX, (String)SIMPLE_PROPERTY_TYPE, Collections.emptyMap(), (String)FACT_TYPE, (FactModelTree.Type)FactModelTree.Type.INPUT);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)"", (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((long)1L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((Object)SIMPLE_PROPERTY_TYPE, (Object)((FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((long)0L, (long)factModelTree.getGenericTypesMap().size());
        Assert.assertEquals((Object)FactModelTree.Type.INPUT, (Object)factModelTree.getType());
        Assert.assertTrue((boolean)factModelTree.isSimple());
        Assert.assertEquals((Object)IMPORT_PREFIX, (Object)factModelTree.getImportPrefix());
    }

    @Test
    public void getTypeNameSetToNull() {
        FactModelTree factModelTree = new FactModelTree(FACT_NAME, PACKAGE, Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactName", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
    }

    @Test
    public void getTypeNameSet() {
        FactModelTree factModelTree = new FactModelTree(FACT_NAME, PACKAGE, Collections.emptyMap(), Collections.emptyMap(), FACT_TYPE);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getTypeName());
        Assert.assertEquals((Object)PACKAGE, (Object)factModelTree.getFullPackage());
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFactName());
        Assert.assertEquals((Object)FactModelTree.Type.UNDEFINED, (Object)factModelTree.getType());
    }

    @Test
    public void getFullTypeName() {
        FactModelTree factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)PACKAGE, Collections.emptyMap(), Collections.emptyMap(), (String)FACT_TYPE);
        Assert.assertEquals((Object)"com.FactType", (Object)factModelTree.getFullTypeName());
        factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)"", Collections.emptyMap(), Collections.emptyMap(), (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getFullTypeName());
        factModelTree = FactModelTree.ofDMO((String)FACT_NAME, null, Collections.emptyMap(), Collections.emptyMap(), (String)FACT_TYPE);
        Assert.assertEquals((Object)FACT_TYPE, (Object)factModelTree.getFullTypeName());
        factModelTree = FactModelTree.ofDMO((String)FACT_NAME, (String)"", Collections.emptyMap(), Collections.emptyMap(), (String)FACT_NAME);
        Assert.assertEquals((Object)FACT_NAME, (Object)factModelTree.getFullTypeName());
    }
}

