/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.workbench.screens.scenariosimulation.client.events;

import com.google.gwt.event.shared.GwtEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioGridBodyRightClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;

public class ScenarioGridBodyRightClickEvent extends GwtEvent<ScenarioGridBodyRightClickHandler> {

    public static Type<ScenarioGridBodyRightClickHandler> TYPE = new Type<>();

    private ScenarioGridPanel scenarioGridPanel;
    private ScenarioGridLayer scenarioGridLayer;
    private final GridCell<?> cell;

    public ScenarioGridBodyRightClickEvent(ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer scenarioGridLayer, GridCell<?> cell) {
        this.scenarioGridPanel = scenarioGridPanel;
        this.scenarioGridLayer = scenarioGridLayer;
        this.cell = cell;
    }

    @Override
    public Type<ScenarioGridBodyRightClickHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(ScenarioGridBodyRightClickHandler handler) {
        handler.onRightClick(this);
    }

    public ScenarioGridPanel getScenarioGridPanel() {
        return scenarioGridPanel;
    }

    public ScenarioGridLayer getScenarioGridLayer() {
        return scenarioGridLayer;
    }

    public GridCell<?> getGridCell() {
        return cell;
    }
}
