/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class ScenarioSimulationGridPanelClickHandler
implements ClickHandler,
ContextMenuHandler {
    private ScenarioGrid scenarioGrid;
    private GridContextMenu gridContextMenu;
    private HeaderContextMenu headerContextMenu;

    public ScenarioSimulationGridPanelClickHandler(ScenarioGrid scenarioGrid, GridContextMenu gridContextMenu, HeaderContextMenu headerContextMenu) {
        this.scenarioGrid = scenarioGrid;
        this.gridContextMenu = gridContextMenu;
        this.headerContextMenu = headerContextMenu;
    }

    public void onClick(ClickEvent event) {
        this.commonClickManagement();
    }

    public void onContextMenu(ContextMenuEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.commonClickManagement();
        this.manageRightClick(event);
    }

    protected void manageRightClick(ContextMenuEvent event) {
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)ap.getX());
        if (uiColumnIndex == null) {
            return;
        }
        if (!this.manageHeaderRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex)) {
            this.manageBodyRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex, isShiftKeyDown, isControlKeyDown);
        }
    }

    protected int getRelativeX(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected int getRelativeY(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    private void commonClickManagement() {
        this.gridContextMenu.hide();
        this.headerContextMenu.hide();
    }

    private boolean manageHeaderRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex) {
        ScenarioHeaderMetaData columnMetadata = ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData((GridWidget)scenarioGrid, (GridColumn)scenarioGrid.getModel().getColumns().get(uiColumnIndex), gridY);
        if (columnMetadata == null) {
            return false;
        }
        this.headerContextMenu.show(left, top);
        return true;
    }

    private boolean manageBodyRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        scenarioGrid.deselect();
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)scenarioGrid, (double)gridY);
        if (uiRowIndex == null) {
            return false;
        }
        this.gridContextMenu.show(left, top);
        return true;
    }
}

