/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.AbstractCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@Dependent
public class SetInstanceHeaderCommand
extends AbstractCommand {
    private ScenarioGridModel model;
    private String fullPackage;
    private String className;

    public SetInstanceHeaderCommand() {
    }

    public SetInstanceHeaderCommand(ScenarioGridModel model, String fullPackage, String className, ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer scenarioGridLayer) {
        super(scenarioGridPanel, scenarioGridLayer);
        this.model = model;
        this.fullPackage = fullPackage;
        this.className = className;
    }

    public void execute() {
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)this.model.getSelectedColumn();
        if (selectedColumn == null) {
            return;
        }
        int columnIndex = this.model.getColumns().indexOf((Object)selectedColumn);
        if (!this.fullPackage.endsWith(".")) {
            this.fullPackage = this.fullPackage + ".";
        }
        String canonicalClassName = this.fullPackage + this.className;
        FactIdentifier factIdentifier = this.getFactIdentifierByColumnTitle(this.className).orElse(FactIdentifier.create((String)selectedColumn.getInformationHeaderMetaData().getColumnId(), (String)canonicalClassName));
        ScenarioHeaderMetaData informationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        informationHeaderMetaData.setTitle(this.className);
        selectedColumn.setInstanceAssigned(true);
        ScenarioHeaderMetaData propertyHeaderMetaData = selectedColumn.getPropertyHeaderMetaData();
        selectedColumn.setPlaceHolder(ScenarioSimulationEditorConstants.INSTANCE.defineValidType());
        propertyHeaderMetaData.setTitle(FactMapping.getPropertyPlaceHolder((int)columnIndex));
        propertyHeaderMetaData.setReadOnly(false);
        selectedColumn.setFactIdentifier(factIdentifier);
        this.model.updateColumnInstance(columnIndex, (GridColumn<?>)selectedColumn);
    }
}

