/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class SetPropertyHeaderCommand
extends AbstractScenarioSimulationCommand {
    public SetPropertyHeaderCommand() {
        super(true);
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)context.getModel().getSelectedColumn();
        if (selectedColumn == null) {
            return;
        }
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        String value = context.getStatus().getValue();
        String title = value.contains(".") ? value.substring(value.indexOf(".") + 1) : "value";
        String className = value.split("\\.")[0];
        String fullPackage = context.getStatus().getFullPackage();
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        String canonicalClassName = fullPackage + className;
        String nameToUseForCreation = context.getModel().getSimulation().get().getSimulationDescriptor().getType().equals((Object)ScenarioSimulationModel.Type.DMN) ? className : selectedColumn.getInformationHeaderMetaData().getColumnId();
        FactIdentifier factIdentifier = this.getFactIdentifierByColumnTitle(className, context).orElse(FactIdentifier.create((String)nameToUseForCreation, (String)canonicalClassName));
        GridData.Range instanceLimits = context.getModel().getInstanceLimits(columnIndex);
        IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).forEach(index -> {
            ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)((Object)context.getModel().getColumns().get(index)));
            if (!scenarioGridColumn.isInstanceAssigned()) {
                scenarioGridColumn.getInformationHeaderMetaData().setTitle(className);
                scenarioGridColumn.setInstanceAssigned(true);
                scenarioGridColumn.setFactIdentifier(factIdentifier);
            }
        });
        String placeHolder = ScenarioSimulationEditorConstants.INSTANCE.insertValue();
        selectedColumn.setPlaceHolder(placeHolder);
        selectedColumn.getPropertyHeaderMetaData().setColumnGroup(ScenarioSimulationUtils.getPropertyMetaDataGroup(selectedColumn.getInformationHeaderMetaData().getColumnGroup()));
        selectedColumn.getPropertyHeaderMetaData().setTitle(title);
        selectedColumn.getPropertyHeaderMetaData().setReadOnly(false);
        selectedColumn.setPropertyAssigned(true);
        context.getModel().updateColumnProperty(columnIndex, (GridColumn<?>)selectedColumn, value, context.getStatus().getValueClassName(), context.getStatus().isKeepData());
        if (context.getScenarioSimulationEditorPresenter() != null) {
            context.getScenarioSimulationEditorPresenter().reloadRightPanel(false);
        }
    }
}

