/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;

public class DMNDataManagementStrategy
implements DataManagementStrategy {
    private final Caller<DMNTypeService> dmnTypeService;
    private Path currentPath;
    private ScenarioSimulationModel model;
    private ResultHolder factModelTreeHolder = new ResultHolder();

    public DMNDataManagementStrategy(Caller<DMNTypeService> dmnTypeService) {
        this.dmnTypeService = dmnTypeService;
    }

    @Override
    public void populateRightPanel(RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        String dmnFilePath = this.model.getSimulation().getSimulationDescriptor().getDmnFilePath();
        if (this.factModelTreeHolder.getFactModelTuple() != null) {
            this.getSuccessCallback(rightPanelPresenter).callback((Object)this.factModelTreeHolder.getFactModelTuple());
        } else {
            ((DMNTypeService)this.dmnTypeService.call(this.getSuccessCallback(rightPanelPresenter), this.getErrorCallback(rightPanelPresenter))).retrieveType(this.currentPath, dmnFilePath);
        }
    }

    @Override
    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.currentPath = currentPath.getOriginal();
        this.model = toManage.getModel();
    }

    private RemoteCallback<FactModelTuple> getSuccessCallback(RightPanelView.Presenter rightPanelPresenter) {
        return factMappingTuple -> {
            this.factModelTreeHolder.setFactModelTuple((FactModelTuple)factMappingTuple);
            SortedMap visibleFacts = factMappingTuple.getVisibleFacts();
            Map<Boolean, List<Map.Entry>> partitionBy = visibleFacts.entrySet().stream().collect(Collectors.partitioningBy(stringFactModelTreeEntry -> ((FactModelTree)stringFactModelTreeEntry.getValue()).isSimple()));
            TreeMap<String, FactModelTree> complexDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            TreeMap<String, FactModelTree> simpleDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            rightPanelPresenter.setDataObjectFieldsMap(complexDataObjects);
            rightPanelPresenter.setSimpleJavaTypeFieldsMap(simpleDataObjects);
            rightPanelPresenter.setHiddenFieldsMap(factMappingTuple.getHiddenFacts());
        };
    }

    private ErrorCallback<Object> getErrorCallback(RightPanelView.Presenter rightPanelPresenter) {
        return (error, exception) -> {
            rightPanelPresenter.setDataObjectFieldsMap(new TreeMap<String, FactModelTree>());
            return false;
        };
    }

    private static class ResultHolder {
        FactModelTuple factModelTuple;

        private ResultHolder() {
        }

        public FactModelTuple getFactModelTuple() {
            return this.factModelTuple;
        }

        public void setFactModelTuple(FactModelTuple factModelTuple) {
            this.factModelTuple = factModelTuple;
        }
    }
}

