/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.ItemEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.KeyValueEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;

public class CollectionPresenter
implements CollectionView.Presenter {
    @Inject
    protected ItemElementPresenter listElementPresenter;
    @Inject
    protected KeyValueElementPresenter mapElementPresenter;
    @Inject
    protected ViewsProvider viewsProvider;
    @Inject
    protected ItemEditingBoxPresenter listEditingBoxPresenter;
    @Inject
    protected KeyValueEditingBoxPresenter mapEditingBoxPresenter;
    protected Map<String, Map<String, String>> instancePropertiesMap = new HashMap<String, Map<String, String>>();
    protected CollectionView collectionView;
    protected LIElement objectSeparatorLI;
    protected boolean toRemove = false;

    @Override
    public void initListStructure(String key, Map<String, String> instancePropertyMap, CollectionView collectionView) {
        this.commonInit(key, collectionView);
        this.instancePropertiesMap.put(key, instancePropertyMap);
        this.listEditingBoxPresenter.setCollectionEditorPresenter(this);
        this.listElementPresenter.setCollectionEditorPresenter(this);
        this.listElementPresenter.onToggleRowExpansion(false);
    }

    @Override
    public void initMapStructure(String key, Map<String, String> keyPropertyMap, Map<String, String> valuePropertyMap, CollectionView collectionView) {
        this.commonInit(key, collectionView);
        this.instancePropertiesMap.put(key + "#key", keyPropertyMap);
        this.instancePropertiesMap.put(key + "#value", valuePropertyMap);
        this.mapEditingBoxPresenter.setCollectionEditorPresenter(this);
        this.mapElementPresenter.setCollectionEditorPresenter(this);
        this.mapElementPresenter.onToggleRowExpansion(false);
    }

    @Override
    public void setValue(String jsonString) {
        this.toRemove = false;
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        JSONValue jsonValue = this.getJSONValue(jsonString);
        if (this.collectionView.isListWidget()) {
            this.populateList(jsonValue);
        } else {
            this.populateMap(jsonValue);
        }
    }

    @Override
    public void showEditingBox() {
        String key = this.collectionView.getEditorTitle().getInnerText();
        if (this.collectionView.isListWidget()) {
            LIElement editingBox = this.listEditingBoxPresenter.getEditingBox(key, this.instancePropertiesMap.get(key));
            this.collectionView.getElementsContainer().appendChild((Node)editingBox);
        } else {
            LIElement editingBox = this.mapEditingBoxPresenter.getEditingBox(key, this.instancePropertiesMap.get(key + "#key"), this.instancePropertiesMap.get(key + "#value"));
            this.collectionView.getElementsContainer().appendChild((Node)editingBox);
        }
        this.toggleEditingStatus(true);
    }

    @Override
    public void onToggleRowExpansion(boolean isShown) {
        this.collectionView.toggleRowExpansion();
        if (this.collectionView.isListWidget()) {
            this.listElementPresenter.onToggleRowExpansion(isShown);
        } else {
            this.mapElementPresenter.onToggleRowExpansion(isShown);
        }
    }

    @Override
    public void addListItem(Map<String, String> propertiesValues) {
        UListElement elementsContainer = this.collectionView.getElementsContainer();
        String itemId = String.valueOf(elementsContainer.getChildCount() - 1);
        LIElement itemElement = this.listElementPresenter.getItemContainer(itemId, propertiesValues);
        elementsContainer.appendChild((Node)itemElement);
        this.toggleEditingStatus(false);
    }

    @Override
    public void addMapItem(Map<String, String> keyPropertiesValues, Map<String, String> valuePropertiesValues) {
        UListElement elementsContainer = this.collectionView.getElementsContainer();
        String itemId = String.valueOf(elementsContainer.getChildCount() - 1);
        LIElement itemElement = this.mapElementPresenter.getKeyValueContainer(itemId, keyPropertiesValues, valuePropertiesValues);
        elementsContainer.appendChild((Node)itemElement);
        this.toggleEditingStatus(false);
    }

    @Override
    public void save() {
        String updatedValue = this.toRemove ? null : (this.collectionView.isListWidget() ? this.getListValue() : this.getMapValue());
        this.collectionView.updateValue(updatedValue);
    }

    @Override
    public void remove() {
        if (this.collectionView.isListWidget()) {
            this.listElementPresenter.remove();
        } else {
            this.mapElementPresenter.remove();
        }
        this.toRemove = true;
    }

    @Override
    public void toggleEditingStatus(boolean toDisable) {
        this.collectionView.getAddItemButton().setDisabled(toDisable);
        this.mapElementPresenter.toggleEditingStatus(toDisable);
        this.listElementPresenter.toggleEditingStatus(toDisable);
    }

    protected void commonInit(String key, CollectionView collectionView) {
        this.toRemove = false;
        this.collectionView = collectionView;
        String propertyName = key.substring(key.lastIndexOf("#") + 1);
        this.collectionView.getEditorTitle().setInnerText(key);
        this.collectionView.getPropertyTitle().setInnerText(propertyName);
        this.objectSeparatorLI = collectionView.getObjectSeparator();
        this.objectSeparatorLI.addClassName("kie-object-list");
        this.objectSeparatorLI.getStyle().setPadding(5.0, Style.Unit.PX);
    }

    protected void populateList(JSONValue jsonValue) {
        JSONArray array = jsonValue.isArray();
        for (int i = 0; i < array.size(); ++i) {
            HashMap<String, String> propertiesValues = new HashMap<String, String>();
            JSONObject jsonObject = array.get(i).isObject();
            jsonObject.keySet().forEach(propertyName -> propertiesValues.put((String)propertyName, jsonObject.get(propertyName).isString().stringValue()));
            this.addListItem(propertiesValues);
        }
    }

    protected void populateMap(JSONValue jsonValue) {
        JSONObject jsValueObject = jsonValue.isObject();
        jsValueObject.keySet().forEach(key -> {
            HashMap<String, String> keyPropertiesValues = new HashMap<String, String>();
            HashMap<String, String> valuePropertiesValues = new HashMap<String, String>();
            JSONObject jsonObjectKey = this.getJSONObject((String)key);
            if (jsonObjectKey == null) {
                keyPropertiesValues.put("value", (String)key);
            } else {
                jsonObjectKey.keySet().forEach(propertyName -> keyPropertiesValues.put((String)propertyName, jsonObjectKey.get(propertyName).isString().stringValue()));
            }
            JSONObject jsonObjectValue = jsValueObject.get(key).isObject();
            if (jsonObjectValue != null) {
                jsonObjectValue.keySet().forEach(propertyName -> valuePropertiesValues.put((String)propertyName, jsonObjectValue.get(propertyName).isString().stringValue()));
            } else {
                valuePropertiesValues.put("value", jsValueObject.get(key).toString());
            }
            this.addMapItem(keyPropertiesValues, valuePropertiesValues);
        });
    }

    protected JSONObject getJSONObject(String jsonString) {
        try {
            return this.getJSONValue(jsonString).isObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected JSONValue getJSONValue(String jsonString) {
        try {
            return JSONParser.parseStrict((String)jsonString);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getListValue() {
        List<Map<String, String>> itemsProperties = this.listElementPresenter.getItemsProperties();
        JSONArray jsonArray = new JSONArray();
        AtomicInteger counter = new AtomicInteger();
        itemsProperties.forEach(stringStringMap -> {
            JSONObject nestedObject = new JSONObject();
            stringStringMap.forEach((propertyName, propertyValue) -> nestedObject.put(propertyName, (JSONValue)new JSONString(propertyValue)));
            jsonArray.set(counter.getAndIncrement(), (JSONValue)nestedObject);
        });
        return jsonArray.toString();
    }

    protected String getMapValue() {
        Map<Map<String, String>, Map<String, String>> itemsProperties = this.mapElementPresenter.getItemsProperties();
        JSONObject toReturnModel = new JSONObject();
        itemsProperties.forEach((keyPropertiesValues, valuePropertiesMap) -> {
            String jsonKey;
            if (keyPropertiesValues.size() == 1) {
                jsonKey = (String)keyPropertiesValues.values().iterator().next();
            } else {
                JSONObject nestedKey = new JSONObject();
                keyPropertiesValues.forEach((propertyName, propertyValue) -> nestedKey.put(propertyName, (JSONValue)new JSONString(propertyValue)));
                jsonKey = nestedKey.toString();
            }
            JSONObject nestedValue = new JSONObject();
            valuePropertiesMap.forEach((propertyName, propertyValue) -> nestedValue.put(propertyName, (JSONValue)new JSONString(propertyValue)));
            toReturnModel.put(jsonKey, (JSONValue)nestedValue);
        });
        return toReturnModel.toString();
    }
}

