/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementView;

public class ItemElementPresenter
extends ElementPresenter<ItemElementView>
implements ItemElementView.Presenter {
    @Override
    public LIElement getItemContainer(String itemId, Map<String, String> propertiesMap) {
        ItemElementView itemElementView = this.viewsProvider.getListEditorElementView();
        itemElementView.init(this);
        itemElementView.setItemId(itemId);
        UListElement innerItemContainer = itemElementView.getInnerItemContainer();
        LIElement saveChange = itemElementView.getSaveChange();
        propertiesMap.forEach((propertyName, propertyValue) -> innerItemContainer.insertBefore((Node)this.propertyPresenter.getPropertyFields(itemId, (String)propertyName, (String)propertyValue), (Node)saveChange));
        this.elementViewList.add(itemElementView);
        return itemElementView.getItemContainer();
    }

    @Override
    public void onToggleRowExpansion(ItemElementView itemElementView, boolean isShown) {
        CollectionEditorUtils.toggleRowExpansion(itemElementView.getFaAngleRight(), !isShown);
        this.propertyPresenter.onToggleRowExpansion(itemElementView.getItemId(), isShown);
    }

    @Override
    public void onEditItem(ItemElementView itemElementView) {
        if (!itemElementView.isShown()) {
            this.onToggleRowExpansion(itemElementView, false);
        }
        this.propertyPresenter.editProperties(itemElementView.getItemId());
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.INLINE);
        this.collectionEditorPresenter.toggleEditingStatus(true);
    }

    @Override
    public void onStopEditingItem(ItemElementView itemElementView) {
        this.propertyPresenter.stopEditProperties(itemElementView.getItemId());
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void updateItem(ItemElementView itemElementView) {
        this.propertyPresenter.updateProperties(itemElementView.getItemId());
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void onDeleteItem(ItemElementView itemElementView) {
        this.propertyPresenter.deleteProperties(itemElementView.getItemId());
        itemElementView.getItemContainer().removeFromParent();
        this.elementViewList.remove(itemElementView);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public List<Map<String, String>> getItemsProperties() {
        return this.elementViewList.stream().map(itemElementView -> this.propertyPresenter.getProperties(itemElementView.getItemId())).collect(Collectors.toList());
    }
}

