/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.domelements;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.events.SetCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class CollectionEditorDOMElement
extends BaseDOMElement<String, CollectionViewImpl>
implements TakesValue<String>,
Focusable {
    protected ScenarioGridCell scenarioGridCell;

    public CollectionEditorDOMElement(CollectionViewImpl widget, GridLayer gridLayer, GridWidget gridWidget) {
        super((Widget)widget, gridLayer, gridWidget);
        Style style = widget.getElement().getStyle();
        style.setWidth(100.0, Style.Unit.PCT);
        style.setHeight(100.0, Style.Unit.PCT);
        style.setPaddingLeft(2.0, Style.Unit.PX);
        style.setPaddingRight(2.0, Style.Unit.PX);
        style.setPaddingTop(2.0, Style.Unit.PX);
        style.setPaddingBottom(2.0, Style.Unit.PX);
        style.setFontSize(10.0, Style.Unit.PX);
        style.setProperty("resize", "none");
        SimplePanel widgetContainer = this.getContainer();
        Element widgetContainerElement = widgetContainer.getElement();
        Style widgetContainerElementStyle = widgetContainerElement.getStyle();
        widgetContainerElementStyle.setPaddingLeft(5.0, Style.Unit.PX);
        widgetContainerElementStyle.setPaddingRight(5.0, Style.Unit.PX);
        widgetContainerElementStyle.setPaddingTop(5.0, Style.Unit.PX);
        widgetContainerElementStyle.setPaddingBottom(5.0, Style.Unit.PX);
        widgetContainer.setWidget((Widget)widget);
    }

    public void setScenarioGridCell(ScenarioGridCell scenarioGridCell) {
        this.scenarioGridCell = scenarioGridCell;
    }

    public void stopEditingMode() {
        if (this.scenarioGridCell != null) {
            this.scenarioGridCell.setEditingMode(false);
        }
    }

    public void initialise(GridBodyCellRenderContext context) {
        this.transform(context);
        Bounds visibleBounds = this.gridLayer.getVisibleBounds();
        double shownWidth = visibleBounds.getWidth();
        double widgetWidth = shownWidth * 0.5;
        double widgetLeft = (shownWidth - widgetWidth) / 2.0;
        this.widgetContainer.getElement().getStyle().setWidth(widgetWidth, Style.Unit.PX);
        this.widgetContainer.getElement().getStyle().setLeft(widgetLeft, Style.Unit.PX);
        double shownHeight = visibleBounds.getHeight();
        double widgetHeight = shownHeight * 0.5;
        ((CollectionViewImpl)this.widget).setFixedHeight(widgetHeight, Style.Unit.PX);
        this.widgetContainer.getElement().getStyle().setTop(0.0, Style.Unit.PX);
    }

    public void setValue(String value) {
        ((CollectionViewImpl)this.getWidget()).setValue(value);
    }

    public String getValue() {
        return ((CollectionViewImpl)this.getWidget()).getValue();
    }

    public int getTabIndex() {
        return ((CollectionViewImpl)this.getWidget()).getTabIndex();
    }

    public void setAccessKey(char key) {
        ((CollectionViewImpl)this.getWidget()).setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        ((CollectionViewImpl)this.getWidget()).setFocus(focused);
    }

    public void setTabIndex(int index) {
        ((CollectionViewImpl)this.getWidget()).setTabIndex(index);
    }

    public void flush(String value) {
        if (this.scenarioGridCell != null) {
            String originalValue;
            this.scenarioGridCell.setEditingMode(false);
            String actualValue = value == null || value.isEmpty() ? null : value;
            String cellValue = (String)this.scenarioGridCell.getValue().getValue();
            String string = originalValue = cellValue == null || cellValue.isEmpty() ? null : cellValue;
            if (Objects.equals(actualValue, originalValue)) {
                return;
            }
        }
        this.internalFlush(value);
    }

    protected void internalFlush(String value) {
        int rowIndex = this.context.getRowIndex();
        int columnIndex = this.context.getColumnIndex();
        ((ScenarioGrid)this.gridWidget).getEventBus().fireEvent((GwtEvent)new SetCellValueEvent(rowIndex, columnIndex, value, false));
    }
}

