/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

public abstract class AbstractDataManagementStrategy
implements DataManagementStrategy {
    protected ScenarioSimulationModel model;

    @Override
    public void setModel(ScenarioSimulationModel model) {
        this.model = model;
    }

    protected static FactModelTree getSimpleClassFactModelTree(Class clazz) {
        String key = clazz.getSimpleName();
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        String fullName = clazz.getCanonicalName();
        simpleProperties.put("value", fullName);
        String packageName = fullName.substring(0, fullName.lastIndexOf("."));
        return new FactModelTree(key, packageName, simpleProperties, new HashMap());
    }

    protected Map<String, List<String>> getPropertiesToHide(ScenarioGridModel scenarioGridModel) {
        HashMap<String, List<String>> toReturn = new HashMap<String, List<String>>();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)scenarioGridModel.getSelectedColumn();
        if (selectedColumn != null && selectedColumn.isInstanceAssigned()) {
            toReturn.put(selectedColumn.getInformationHeaderMetaData().getTitle(), this.getPropertiesToHide(selectedColumn, scenarioGridModel));
        }
        return toReturn;
    }

    protected List<String> getPropertiesToHide(ScenarioGridColumn selectedColumn, ScenarioGridModel scenarioGridModel) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (!selectedColumn.isPropertyAssigned()) {
            scenarioGridModel.getSimulation().ifPresent(simulation -> {
                SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
                List<ScenarioGridColumn> instanceColumns = scenarioGridModel.getInstanceScenarioGridColumns(selectedColumn);
                toReturn.addAll(instanceColumns.stream().filter(ScenarioGridColumn::isPropertyAssigned).map(instanceColumn -> scenarioGridModel.getColumns().indexOf(instanceColumn)).map(columnIndex -> {
                    List expressionElements = simulationDescriptor.getFactMappingByIndex(columnIndex.intValue()).getExpressionElements();
                    expressionElements.get(expressionElements.size() - 1);
                    return ((ExpressionElement)expressionElements.get(expressionElements.size() - 1)).getStep();
                }).collect(Collectors.toList()));
            });
        }
        return toReturn;
    }
}

