/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

public class DMODataManagementStrategy
extends AbstractDataManagementStrategy {
    private AsyncPackageDataModelOracleFactory oracleFactory;
    protected AsyncPackageDataModelOracle oracle;
    protected ScenarioSimulationContext scenarioSimulationContext;
    protected String packageName = "";

    public DMODataManagementStrategy(AsyncPackageDataModelOracleFactory oracleFactory, ScenarioSimulationContext scenarioSimulationContext) {
        this.oracleFactory = oracleFactory;
        this.scenarioSimulationContext = scenarioSimulationContext;
    }

    @Override
    public void populateRightPanel(RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        if (this.oracle == null || this.oracle.getFactTypes().length == 0) {
            return;
        }
        List<String> factTypes = Arrays.asList(this.oracle.getFactTypes());
        Map<Boolean, List<String>> partitionedFactTypes = factTypes.stream().collect(Collectors.partitioningBy(factType -> SIMPLE_CLASSES_MAP.keySet().contains(factType)));
        List<String> dataObjectsTypes = partitionedFactTypes.get(false);
        List<String> simpleJavaTypes = partitionedFactTypes.get(true);
        int expectedElements = dataObjectsTypes.size();
        TreeMap<String, FactModelTree> dataObjectsFieldsMap = new TreeMap<String, FactModelTree>();
        Map<String, List<String>> propertiesToHide = this.getPropertiesToHide(scenarioGridModel);
        Callback<FactModelTree> aggregatorCallback = this.aggregatorCallback(rightPanelPresenter, expectedElements, dataObjectsFieldsMap, propertiesToHide, scenarioGridModel);
        dataObjectsTypes.forEach(factType -> this.oracle.getFieldCompletions(factType, this.fieldCompletionsCallback((String)factType, aggregatorCallback)));
        this.populateSimpleJavaTypes(simpleJavaTypes, rightPanelPresenter, scenarioGridModel);
    }

    @Override
    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.model = toManage.getModel();
        this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)currentPath, (HasImports)this.model, toManage.getDataModel());
    }

    @Override
    public boolean isADataType(String value) {
        return this.oracle != null && Arrays.asList(this.oracle.getFactTypes()).contains(value);
    }

    public AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    protected Callback<ModelField[]> fieldCompletionsCallback(String factName, Callback<FactModelTree> aggregatorCallback) {
        return result -> this.fieldCompletionsCallbackMethod(factName, (ModelField[])result, aggregatorCallback);
    }

    protected void fieldCompletionsCallbackMethod(String factName, ModelField[] result, Callback<FactModelTree> aggregatorCallback) {
        FactModelTree toSend = this.getFactModelTree(factName, result);
        aggregatorCallback.callback((Object)toSend);
    }

    protected void populateSimpleJavaTypes(List<String> simpleJavaTypes, RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        TreeMap<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>();
        simpleJavaTypes.forEach(factType -> simpleJavaTypeFieldsMap.put((String)factType, DMODataManagementStrategy.getSimpleClassFactModelTree((Class)SIMPLE_CLASSES_MAP.get(factType))));
        rightPanelPresenter.setSimpleJavaTypeFieldsMap(simpleJavaTypeFieldsMap);
        SortedMap<String, FactModelTree> simpleJavaTypeInstanceFieldsMap = this.getInstanceMap(simpleJavaTypeFieldsMap);
        rightPanelPresenter.setSimpleJavaInstanceFieldsMap(simpleJavaTypeInstanceFieldsMap);
        HashSet<String> simpleJavaTypeInstancesName = new HashSet<String>(simpleJavaTypeFieldsMap.keySet());
        simpleJavaTypeInstancesName.addAll(simpleJavaTypeInstanceFieldsMap.keySet());
        scenarioGridModel.setSimpleJavaTypeInstancesName(simpleJavaTypeInstancesName);
    }

    protected SortedMap<String, FactModelTree> getInstanceMap(SortedMap<String, FactModelTree> sourceMap) {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        if (this.model != null) {
            SimulationDescriptor simulationDescriptor = this.model.getSimulation().getSimulationDescriptor();
            simulationDescriptor.getUnmodifiableFactMappings().stream().filter(factMapping -> !Objects.equals(FactMappingType.OTHER, factMapping.getExpressionIdentifier().getType())).forEach(factMapping -> {
                FactModelTree factModelTree;
                String instanceName;
                String dataObjectName = factMapping.getFactIdentifier().getClassName();
                if (dataObjectName.contains(".")) {
                    dataObjectName = dataObjectName.substring(dataObjectName.lastIndexOf(".") + 1);
                }
                if (!(instanceName = factMapping.getFactAlias()).equals(dataObjectName) && (factModelTree = (FactModelTree)sourceMap.get(dataObjectName)) != null) {
                    toReturn.put(instanceName, factModelTree);
                }
            });
        }
        return toReturn;
    }

    protected FactModelTree getFactModelTree(String factName, ModelField[] modelFields) {
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        HashMap<String, List<String>> genericTypesMap = new HashMap<String, List<String>>();
        String factPackageName = this.packageName;
        String fullFactClassName = this.oracle.getFQCNByFactName(factName);
        if (fullFactClassName != null && fullFactClassName.contains(".")) {
            factPackageName = fullFactClassName.substring(0, fullFactClassName.lastIndexOf("."));
        }
        for (ModelField modelField : modelFields) {
            if (modelField.getName().equals("this")) continue;
            String className = SIMPLE_CLASSES_MAP.containsKey(modelField.getClassName()) ? ((Class)SIMPLE_CLASSES_MAP.get(modelField.getClassName())).getCanonicalName() : modelField.getClassName();
            simpleProperties.put(modelField.getName(), className);
            if (!ScenarioSimulationSharedUtils.isCollection((String)className)) continue;
            this.populateGenericTypeMap(genericTypesMap, factName, modelField.getName(), ScenarioSimulationSharedUtils.isList((String)className));
        }
        return new FactModelTree(factName, factPackageName, simpleProperties, genericTypesMap);
    }

    protected void populateGenericTypeMap(Map<String, List<String>> toPopulate, String factName, String propertyName, boolean isList) {
        ArrayList<String> genericTypes = new ArrayList<String>();
        if (!isList) {
            genericTypes.add(String.class.getName());
        }
        String genericInfo = this.oracle.getParametricFieldType(factName, propertyName);
        String fullGenericInfoClassName = this.oracle.getFQCNByFactName(genericInfo);
        genericTypes.add(fullGenericInfoClassName);
        toPopulate.put(propertyName, genericTypes);
    }

    protected Callback<FactModelTree> aggregatorCallback(RightPanelView.Presenter rightPanelPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, Map<String, List<String>> propertiesToHide, ScenarioGridModel scenarioGridModel) {
        return result -> this.aggregatorCallbackMethod(rightPanelPresenter, expectedElements, factTypeFieldsMap, propertiesToHide, scenarioGridModel, (FactModelTree)result);
    }

    protected void aggregatorCallbackMethod(RightPanelView.Presenter rightPanelPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, Map<String, List<String>> propertiesToHide, ScenarioGridModel scenarioGridModel, FactModelTree result) {
        factTypeFieldsMap.put(result.getFactName(), result);
        if (factTypeFieldsMap.size() == expectedElements) {
            factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModelTree((FactModelTree)factModelTree, factTypeFieldsMap, propertiesToHide));
            rightPanelPresenter.setDataObjectFieldsMap(factTypeFieldsMap);
            this.scenarioSimulationContext.setDataObjectFieldsMap(factTypeFieldsMap);
            SortedMap<String, FactModelTree> instanceFieldsMap = this.getInstanceMap(factTypeFieldsMap);
            rightPanelPresenter.setInstanceFieldsMap(instanceFieldsMap);
            HashSet<String> dataObjectsInstancesName = new HashSet<String>(factTypeFieldsMap.keySet());
            dataObjectsInstancesName.addAll(instanceFieldsMap.keySet());
            scenarioGridModel.setDataObjectsInstancesName(dataObjectsInstancesName);
        }
    }

    protected void populateFactModelTree(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap, Map<String, List<String>> propertiesToHide) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value)) {
                toRemove.add(key);
                toPopulate.addExpandableProperty(key, ((FactModelTree)factTypeFieldsMap.get(value)).getFactName());
            }
        });
        if (propertiesToHide.containsKey(toPopulate.getFactName())) {
            toRemove.addAll(propertiesToHide.get(toPopulate.getFactName()));
        }
        toRemove.forEach(arg_0 -> ((FactModelTree)toPopulate).removeSimpleProperty(arg_0));
    }
}

