/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class CommonEditHandler {
    public static boolean startEdit(ScenarioGrid scenarioGrid, Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn, Integer uiRowIndex, boolean isHeader, EventBus eventBus) {
        if (isHeader) {
            return CommonEditHandler.manageHeaderLeftClick(scenarioGrid, uiColumnIndex, scenarioGridColumn, uiRowIndex, eventBus);
        }
        return CommonEditHandler.manageGridLeftClick(scenarioGrid, uiRowIndex, uiColumnIndex, scenarioGridColumn);
    }

    protected static boolean manageHeaderLeftClick(ScenarioGrid scenarioGrid, Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn, Integer uiHeaderRowIndex, EventBus eventBus) {
        if (!CommonEditHandler.isEditableHeaderLocal(scenarioGridColumn, uiHeaderRowIndex)) {
            return false;
        }
        ScenarioHeaderMetaData clickedScenarioHeaderMetadata = (ScenarioHeaderMetaData)((Object)scenarioGridColumn.getHeaderMetaData().get(uiHeaderRowIndex));
        if (clickedScenarioHeaderMetadata == null) {
            return false;
        }
        String group = clickedScenarioHeaderMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        switch (group) {
            case "GIVEN": 
            case "EXPECT": {
                return CommonEditHandler.manageGivenExpectHeaderLeftClick(scenarioGrid, clickedScenarioHeaderMetadata, scenarioGridColumn, group, uiColumnIndex, eventBus);
            }
        }
        return false;
    }

    protected static boolean manageGivenExpectHeaderLeftClick(ScenarioGrid scenarioGrid, ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex, EventBus eventBus) {
        scenarioGrid.setSelectedColumnAndHeader(scenarioGridColumn.getHeaderMetaData().indexOf((Object)clickedScenarioHeaderMetadata), uiColumnIndex);
        if (scenarioGridColumn.isInstanceAssigned() && clickedScenarioHeaderMetadata.isInstanceHeader()) {
            eventBus.fireEvent((GwtEvent)new ReloadRightPanelEvent(true, true));
            return true;
        }
        EnableRightPanelEvent toFire = ScenarioSimulationGridHeaderUtilities.getEnableRightPanelEvent(scenarioGrid, scenarioGridColumn, clickedScenarioHeaderMetadata, uiColumnIndex, group);
        eventBus.fireEvent((GwtEvent)toFire);
        return true;
    }

    public static boolean manageGridLeftClick(ScenarioGrid scenarioGrid, Integer uiRowIndex, Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn) {
        GridCell cell = scenarioGrid.getModel().getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        if (((ScenarioGridCell)cell).isEditingMode()) {
            return true;
        }
        ((ScenarioGridCell)cell).setEditingMode(!scenarioGridColumn.isReadOnly() && scenarioGrid.startEditingCell(uiRowIndex, uiColumnIndex));
        return ((ScenarioGridCell)cell).isEditingMode();
    }

    protected static ScenarioHeaderMetaData getColumnScenarioHeaderMetaDataLocal(ScenarioGrid scenarioGrid, Point2D point) {
        return ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData((GridWidget)scenarioGrid, point);
    }

    protected static Integer getUiHeaderRowIndexLocal(ScenarioGrid scenarioGrid, Point2D point) {
        return CoordinateUtilities.getUiHeaderRowIndex((GridWidget)scenarioGrid, (Point2D)point);
    }

    protected static boolean isEditableHeaderLocal(GridColumn<?> scenarioGridColumn, Integer uiHeaderRowIndex) {
        return ScenarioSimulationGridHeaderUtilities.isEditableHeader(scenarioGridColumn, uiHeaderRowIndex);
    }
}

