/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.CommonEditHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@Dependent
public class ScenarioSimulationGridPanelClickHandler
implements ClickHandler,
ContextMenuHandler {
    protected ScenarioGrid scenarioGrid;
    protected OtherContextMenu otherContextMenu;
    protected HeaderGivenContextMenu headerGivenContextMenu;
    protected HeaderExpectedContextMenu headerExpectedContextMenu;
    protected GivenContextMenu givenContextMenu;
    protected ExpectedContextMenu expectedContextMenu;
    protected GridContextMenu gridContextMenu;
    protected UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu;
    protected Set<AbstractHeaderMenuPresenter> managedMenus = new HashSet<AbstractHeaderMenuPresenter>();
    protected EventBus eventBus;
    protected AtomicInteger clickReceived = new AtomicInteger(0);
    protected BaseGridRendererHelper rendererHelper;

    public void setScenarioGrid(ScenarioGrid scenarioGrid) {
        this.scenarioGrid = scenarioGrid;
        this.rendererHelper = scenarioGrid.getRendererHelper();
    }

    public void setOtherContextMenu(OtherContextMenu otherContextMenu) {
        this.otherContextMenu = otherContextMenu;
        this.managedMenus.add(otherContextMenu);
    }

    public void setHeaderGivenContextMenu(HeaderGivenContextMenu headerGivenContextMenu) {
        this.headerGivenContextMenu = headerGivenContextMenu;
        this.managedMenus.add(headerGivenContextMenu);
    }

    public void setHeaderExpectedContextMenu(HeaderExpectedContextMenu headerExpectedContextMenu) {
        this.headerExpectedContextMenu = headerExpectedContextMenu;
        this.managedMenus.add(headerExpectedContextMenu);
    }

    public void setGivenContextMenu(GivenContextMenu givenContextMenu) {
        this.givenContextMenu = givenContextMenu;
        this.managedMenus.add(givenContextMenu);
    }

    public void setExpectedContextMenu(ExpectedContextMenu expectedContextMenu) {
        this.expectedContextMenu = expectedContextMenu;
        this.managedMenus.add(expectedContextMenu);
    }

    public void setGridContextMenu(GridContextMenu gridContextMenu) {
        this.gridContextMenu = gridContextMenu;
        this.managedMenus.add(gridContextMenu);
    }

    public void setUnmodifiableColumnGridContextMenu(UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu) {
        this.unmodifiableColumnGridContextMenu = unmodifiableColumnGridContextMenu;
        this.managedMenus.add(unmodifiableColumnGridContextMenu);
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.managedMenus.forEach(menu -> menu.setEventBus(eventBus));
    }

    public void onClick(ClickEvent event) {
        this.clickReceived.getAndIncrement();
        int canvasX = CoordinateUtilities.getRelativeXOfEvent((DomEvent)event);
        int canvasY = CoordinateUtilities.getRelativeYOfEvent((DomEvent)event);
        this.hideMenus();
        this.scenarioGrid.clearSelections();
        if (!this.manageLeftClick(canvasX, canvasY)) {
            this.eventBus.fireEvent((GwtEvent)new DisableRightPanelEvent());
        }
    }

    public void onContextMenu(ContextMenuEvent event) {
        this.hideMenus();
        if (this.manageRightClick(event)) {
            event.preventDefault();
            event.stopPropagation();
        }
    }

    public void hideMenus() {
        this.managedMenus.forEach(BaseMenu::hide);
    }

    protected boolean manageRightClick(ContextMenuEvent event) {
        int canvasY;
        int canvasX = CoordinateUtilities.getRelativeXOfEvent((DomEvent)event);
        Point2D gridClickPoint = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)(canvasY = CoordinateUtilities.getRelativeYOfEvent((DomEvent)event))));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)gridClickPoint.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        if (!this.manageHeaderRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), gridClickPoint, uiColumnIndex)) {
            return this.manageBodyRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), gridClickPoint.getY(), uiColumnIndex);
        }
        return true;
    }

    protected boolean manageHeaderRightClick(ScenarioGrid scenarioGrid, int left, int top, Point2D clickPoint, Integer uiColumnIndex) {
        ScenarioHeaderMetaData columnMetadata = this.getColumnScenarioHeaderMetaDataLocal(clickPoint);
        if (columnMetadata == null) {
            return false;
        }
        Integer uiHeaderRowIndex = this.getUiHeaderRowIndexLocal(clickPoint);
        if (uiHeaderRowIndex == null) {
            return false;
        }
        String group = columnMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        block5 : switch (group) {
            case "": {
                switch (columnMetadata.getTitle()) {
                    case "GIVEN": {
                        this.headerGivenContextMenu.show(left, top);
                        break block5;
                    }
                    case "EXPECT": {
                        this.headerExpectedContextMenu.show(left, top);
                        break block5;
                    }
                }
                this.otherContextMenu.show(left, top);
                break;
            }
            case "GIVEN": {
                this.givenContextMenu.show(left, top, uiColumnIndex, group, columnMetadata.isPropertyHeader());
                break;
            }
            case "EXPECT": {
                this.expectedContextMenu.show(left, top, uiColumnIndex, group, columnMetadata.isPropertyHeader());
                break;
            }
            default: {
                this.otherContextMenu.show(left, top);
            }
        }
        scenarioGrid.setSelectedColumnAndHeader(uiHeaderRowIndex, uiColumnIndex);
        return true;
    }

    protected boolean manageBodyRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex) {
        String group;
        scenarioGrid.deselect();
        Integer uiRowIndex = this.getUiRowIndexLocal(gridY);
        if (uiRowIndex == null) {
            return false;
        }
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        switch (group = scenarioGridColumn.getInformationHeaderMetaData().getColumnGroup()) {
            case "GIVEN": 
            case "EXPECT": {
                this.gridContextMenu.show(left, top, uiColumnIndex, uiRowIndex, group, true);
                break;
            }
            default: {
                this.unmodifiableColumnGridContextMenu.show(left, top, uiRowIndex);
            }
        }
        return true;
    }

    protected boolean manageLeftClick(int canvasX, int canvasY) {
        Point2D gridClickPoint = this.convertDOMToGridCoordinateLocal(canvasX, canvasY);
        Integer uiRowIndex = this.getUiHeaderRowIndexLocal(gridClickPoint);
        boolean isHeader = true;
        if (uiRowIndex == null) {
            uiRowIndex = this.getUiRowIndexLocal(gridClickPoint.getY());
            isHeader = false;
        }
        if (uiRowIndex == null) {
            return false;
        }
        Integer uiColumnIndex = this.getUiColumnIndexLocal(gridClickPoint.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)this.scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        if (isHeader) {
            return this.manageHeaderLeftClick(uiColumnIndex, scenarioGridColumn, gridClickPoint);
        }
        return this.manageGridLeftClick(uiRowIndex, uiColumnIndex);
    }

    protected boolean manageHeaderLeftClick(Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn, Point2D clickPoint) {
        Integer uiHeaderRowIndex = this.getUiHeaderRowIndexLocal(clickPoint);
        if (uiHeaderRowIndex == null) {
            return false;
        }
        ScenarioHeaderMetaData clickedScenarioHeaderMetadata = this.getColumnScenarioHeaderMetaDataLocal(clickPoint);
        if (clickedScenarioHeaderMetadata == null) {
            return false;
        }
        String group = clickedScenarioHeaderMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        switch (group) {
            case "GIVEN": 
            case "EXPECT": {
                return this.manageGivenExpectHeaderLeftClick(clickedScenarioHeaderMetadata, scenarioGridColumn, group, uiColumnIndex);
            }
        }
        return false;
    }

    protected boolean manageGivenExpectHeaderLeftClick(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex) {
        this.scenarioGrid.setSelectedColumnAndHeader(scenarioGridColumn.getHeaderMetaData().indexOf((Object)clickedScenarioHeaderMetadata), uiColumnIndex);
        if (scenarioGridColumn.isInstanceAssigned() && clickedScenarioHeaderMetadata.isInstanceHeader()) {
            this.eventBus.fireEvent((GwtEvent)new ReloadRightPanelEvent(true, true));
            return true;
        }
        EnableRightPanelEvent toFire = ScenarioSimulationGridHeaderUtilities.getEnableRightPanelEvent(this.scenarioGrid, scenarioGridColumn, clickedScenarioHeaderMetadata, uiColumnIndex, group);
        this.eventBus.fireEvent((GwtEvent)toFire);
        return true;
    }

    protected boolean manageGridLeftClick(Integer uiRowIndex, Integer uiColumnIndex) {
        GridCell cell = this.scenarioGrid.getModel().getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        this.scenarioGrid.getModel().selectCell(uiRowIndex, uiColumnIndex);
        return true;
    }

    protected Integer getUiHeaderRowIndexLocal(Point2D clickPoint) {
        return CommonEditHandler.getUiHeaderRowIndexLocal(this.scenarioGrid, clickPoint);
    }

    protected Integer getUiRowIndexLocal(double relativeY) {
        return CoordinateUtilities.getUiRowIndex((GridWidget)this.scenarioGrid, (double)relativeY);
    }

    protected Integer getUiColumnIndexLocal(double relativeX) {
        return CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)relativeX);
    }

    protected Point2D convertDOMToGridCoordinateLocal(double canvasX, double canvasY) {
        return CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D(canvasX, canvasY));
    }

    protected ScenarioHeaderMetaData getColumnScenarioHeaderMetaDataLocal(Point2D clickPoint) {
        return CommonEditHandler.getColumnScenarioHeaderMetaDataLocal(this.scenarioGrid, clickPoint);
    }
}

