/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Composite;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated(stylesheet="/org/drools/workbench/screens/scenariosimulation/client/resources/css/ScenarioSimulationEditorStyles.css")
public class RightPanelViewImpl
extends Composite
implements RightPanelView {
    private RightPanelView.Presenter presenter;
    @DataField(value="rightPanelTabs")
    private UListElement rightPanelTabs = Document.get().createULElement();
    @DataField(value="clearSearchButton")
    protected ButtonElement clearSearchButton = Document.get().createButtonElement();
    @DataField(value="searchButton")
    protected ButtonElement searchButton = Document.get().createButtonElement();
    @DataField(value="inputSearch")
    protected InputElement inputSearch = Document.get().createTextInputElement();
    @DataField(value="nameField")
    protected InputElement nameField = Document.get().createTextInputElement();
    @DataField(value="dataObjectListContainer")
    protected DivElement dataObjectListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaTypeListContainer")
    protected DivElement simpleJavaTypeListContainer = Document.get().createDivElement();
    @DataField(value="instanceListContainer")
    protected DivElement instanceListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaInstanceListContainer")
    protected DivElement simpleJavaInstanceListContainer = Document.get().createDivElement();
    @DataField(value="conditionsButton")
    protected ButtonElement conditionsButton = Document.get().createButtonElement();
    @DataField(value="addButton")
    protected ButtonElement addButton = Document.get().createButtonElement();
    @DataField(value="kieTestEditorTabContent")
    protected DivElement kieTestEditorTabContent = Document.get().createDivElement();
    @Inject
    @DataField(value="ruleCheatSheet")
    protected DivElement ruleCheatSheet = Document.get().createDivElement();
    @Inject
    @DataField(value="dmnCheatSheet")
    protected DivElement dmnCheatSheet = Document.get().createDivElement();
    protected List<DivElement> managedDivElements = Arrays.asList(this.dataObjectListContainer, this.simpleJavaTypeListContainer, this.instanceListContainer, this.simpleJavaTypeListContainer);

    public void init(RightPanelView.Presenter presenter) {
        this.presenter = presenter;
        this.disableEditorTab();
        this.addButton.setDisabled(true);
    }

    @Override
    public RightPanelView.Presenter getPresenter() {
        return this.presenter;
    }

    @EventHandler(value={"clearSearchButton"})
    public void onClearSearchButtonClick(ClickEvent event) {
        this.presenter.onClearSearch();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyUp(KeyUpEvent event) {
        this.presenter.onShowClearButton();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyDownEvent(KeyDownEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.presenter.onSearchedEvent(this.inputSearch.getValue());
        }
    }

    @EventHandler(value={"searchButton"})
    public void onSearchButtonClicked(ClickEvent event) {
        this.presenter.onSearchedEvent(this.inputSearch.getValue());
    }

    @EventHandler(value={"addButton"})
    public void onAddButtonClicked(ClickEvent event) {
        this.presenter.onModifyColumn();
        this.addButton.setDisabled(true);
        this.presenter.onDisableEditorTab();
    }

    @Override
    public void clearInputSearch() {
        this.inputSearch.setValue("");
    }

    @Override
    public void clearNameField() {
        this.nameField.setValue("");
    }

    @Override
    public void hideClearButton() {
        this.clearSearchButton.setDisabled(true);
        this.clearSearchButton.setAttribute("style", "display: none;");
    }

    @Override
    public void showClearButton() {
        this.clearSearchButton.setDisabled(false);
        this.clearSearchButton.removeAttribute("style");
    }

    @Override
    public DivElement getDataObjectListContainer() {
        return this.dataObjectListContainer;
    }

    @Override
    public DivElement getSimpleJavaTypeListContainer() {
        return this.simpleJavaTypeListContainer;
    }

    @Override
    public DivElement getInstanceListContainer() {
        return this.instanceListContainer;
    }

    @Override
    public DivElement getSimpleJavaInstanceListContainer() {
        return this.simpleJavaInstanceListContainer;
    }

    @Override
    public void enableEditorTab() {
        this.setDisabledStatus(false);
    }

    @Override
    public void disableEditorTab() {
        this.setDisabledStatus(true);
    }

    @Override
    public void enableAddButton() {
        this.addButton.setDisabled(false);
    }

    protected void setDisabledStatus(boolean disabled) {
        this.clearSearchButton.setDisabled(disabled);
        this.searchButton.setDisabled(disabled);
        this.inputSearch.setDisabled(disabled);
        this.nameField.setDisabled(disabled);
        this.conditionsButton.setDisabled(disabled);
        this.setContainersDisabledStatus(disabled);
        if (disabled) {
            this.kieTestEditorTabContent.addClassName("disabled");
        } else {
            this.kieTestEditorTabContent.removeClassName("disabled");
        }
    }

    protected void setContainersDisabledStatus(boolean disabled) {
        if (disabled) {
            this.managedDivElements.forEach(divElement -> divElement.addClassName("disabled"));
        } else {
            this.managedDivElements.forEach(divElement -> divElement.removeClassName("disabled"));
        }
    }

    @Override
    public void setRuleCheatSheetContent() {
        this.ruleCheatSheet.getStyle().setDisplay(Style.Display.BLOCK);
        this.dmnCheatSheet.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void setDMNCheatSheetContent() {
        this.ruleCheatSheet.getStyle().setDisplay(Style.Display.NONE);
        this.dmnCheatSheet.getStyle().setDisplay(Style.Display.BLOCK);
    }
}

