/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSetHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class SetPropertyHeaderCommand
extends AbstractSetHeaderCommand {
    @Override
    protected void executeIfSelectedColumn(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn) {
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        String value = context.getStatus().getValue();
        String className = value.split("\\.")[0];
        String canonicalClassName = this.getFullPackage(context) + className;
        FactIdentifier factIdentifier = this.setEditableHeadersAndGetFactIdentifier(context, selectedColumn, className, canonicalClassName);
        String propertyHeaderTitle = this.getPropertyHeaderTitle(context, factIdentifier);
        GridData.Range instanceLimits = context.getModel().getInstanceLimits(columnIndex);
        IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).forEach(index -> {
            ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)((Object)context.getModel().getColumns().get(index)));
            if (!scenarioGridColumn.isInstanceAssigned()) {
                this.setInstanceHeaderMetaData(scenarioGridColumn, className, factIdentifier);
            }
        });
        selectedColumn.getPropertyHeaderMetaData().setColumnGroup(ScenarioSimulationUtils.getPropertyMetaDataGroup(selectedColumn.getInformationHeaderMetaData().getColumnGroup()));
        this.setPropertyMetaData(selectedColumn.getPropertyHeaderMetaData(), propertyHeaderTitle, false, selectedColumn, ScenarioSimulationEditorConstants.INSTANCE.insertValue());
        selectedColumn.setPropertyAssigned(true);
        String propertyClass = context.getStatus().getValueClassName();
        context.getModel().updateColumnProperty(columnIndex, (GridColumn<?>)selectedColumn, value, propertyClass, context.getStatus().isKeepData());
        if (ScenarioSimulationSharedUtils.isCollection((String)propertyClass)) {
            SortedMap<String, FactModelTree> dataObjectFieldsMap = context.getDataObjectFieldsMap();
            List<String> elements = Arrays.asList(context.getStatus().getValue().split("\\."));
            FactModelTree nestedFactModelTree = this.navigateComplexObject((FactModelTree)dataObjectFieldsMap.get(className), elements, dataObjectFieldsMap);
            selectedColumn.setFactory(context.getCollectionEditorSingletonDOMElementFactory());
            FactMapping factMappingByIndex = context.getModel().getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            factMappingByIndex.setGenericTypes(nestedFactModelTree.getGenericTypeInfo(elements.get(elements.size() - 1)));
        } else {
            selectedColumn.setFactory(context.getScenarioCellTextAreaSingletonDOMElementFactory());
        }
        if (context.getScenarioSimulationEditorPresenter() != null) {
            context.getScenarioSimulationEditorPresenter().reloadRightPanel(false);
        }
    }

    protected FactModelTree navigateComplexObject(FactModelTree factModelTree, List<String> elements, SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        FactModelTree nestedFactModelTree = factModelTree;
        if (elements.size() > 2) {
            for (String step : elements.subList(1, elements.size() - 1)) {
                if (!nestedFactModelTree.getExpandableProperties().containsKey(step)) continue;
                nestedFactModelTree = (FactModelTree)dataObjectFieldsMap.get(factModelTree.getExpandableProperties().get(step));
            }
        }
        return nestedFactModelTree;
    }

    protected String getPropertyHeaderTitle(ScenarioSimulationContext context, FactIdentifier factIdentifier) {
        String value = context.getStatus().getValue();
        String toReturn = value.contains(".") ? value.substring(value.indexOf(".") + 1) : "value";
        List factMappingsByFactName = context.getStatus().getSimulation().getSimulationDescriptor().getFactMappingsByFactName(factIdentifier.getName());
        Optional<FactMapping> matchingFactMapping = factMappingsByFactName.stream().filter(factMapping -> Objects.equals(factMapping.getFullExpression(), value)).findFirst();
        if (matchingFactMapping.isPresent()) {
            toReturn = matchingFactMapping.get().getExpressionAlias();
        }
        return toReturn;
    }
}

