/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.CollectionEditorSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.workbench.events.NotificationEvent;

public class ScenarioGridModel
extends BaseGridData {
    public static final int HEADER_ROW_COUNT = 3;
    protected Simulation simulation;
    protected EventBus eventBus;
    protected AtomicInteger columnCounter = new AtomicInteger(0);
    protected GridColumn<?> selectedColumn = null;
    protected Set<String> dataObjectsInstancesName;
    protected Set<String> simpleJavaTypeInstancesName;
    protected CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory;
    protected ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory;
    protected ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory;

    public ScenarioGridModel() {
    }

    public ScenarioGridModel(boolean isMerged) {
        super(isMerged);
        this.setHeaderRowCount(3);
    }

    public void bindContent(Simulation simulation) {
        this.simulation = simulation;
        this.checkSimulation();
        this.columnCounter.set(simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int nextColumnCount() {
        return this.columnCounter.getAndIncrement();
    }

    public Map.Entry<String, String> getValidPlaceholders() {
        String propertyTitle;
        String instanceTitle;
        do {
            int nextColumnCount = this.nextColumnCount();
            instanceTitle = FactMapping.getInstancePlaceHolder((int)nextColumnCount);
            propertyTitle = FactMapping.getPropertyPlaceHolder((int)nextColumnCount);
        } while (!this.isNewInstanceName(instanceTitle) || !this.isNewPropertyName(propertyTitle));
        return new AbstractMap.SimpleEntry<String, String>(instanceTitle, propertyTitle);
    }

    public CollectionEditorSingletonDOMElementFactory getCollectionEditorSingletonDOMElementFactory() {
        return this.collectionEditorSingletonDOMElementFactory;
    }

    public void setCollectionEditorSingletonDOMElementFactory(CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory) {
        this.collectionEditorSingletonDOMElementFactory = collectionEditorSingletonDOMElementFactory;
    }

    public ScenarioCellTextAreaSingletonDOMElementFactory getScenarioCellTextAreaSingletonDOMElementFactory() {
        return this.scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public void setScenarioCellTextAreaSingletonDOMElementFactory(ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory) {
        this.scenarioCellTextAreaSingletonDOMElementFactory = scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        return this.scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public void setScenarioHeaderTextBoxSingletonDOMElementFactory(ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory) {
        this.scenarioHeaderTextBoxSingletonDOMElementFactory = scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public void appendRow(GridRow row) {
        this.checkSimulation();
        super.appendRow(row);
        int rowIndex = this.getRowCount() - 1;
        this.commonAddRow(rowIndex);
    }

    public void insertRowGridOnly(int rowIndex, GridRow row, Scenario scenario) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        scenario.getUnmodifiableFactMappingValues().forEach(value -> {
            FactIdentifier factIdentifier = value.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = value.getExpressionIdentifier();
            if (value.getRawValue() != null && !(value.getRawValue() instanceof String)) {
                throw new UnsupportedOperationException("Only string is supported at the moment");
            }
            String stringValue = (String)value.getRawValue();
            int columnIndex = this.simulation.getSimulationDescriptor().getIndexByIdentifier(factIdentifier, expressionIdentifier);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            String placeHolder = ((ScenarioGridColumn)((Object)((Object)this.columns.get(columnIndex)))).getPlaceHolder();
            this.setCell(rowIndex, columnIndex, () -> {
                ScenarioGridCell newCell = new ScenarioGridCell(new ScenarioGridCellValue(stringValue, placeHolder));
                if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                    newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
                }
                return newCell;
            });
        });
        this.updateIndexColumn();
    }

    public void insertRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        this.commonAddRow(rowIndex);
    }

    public GridData.Range deleteRow(int rowIndex) {
        this.checkSimulation();
        GridData.Range toReturn = super.deleteRow(rowIndex);
        this.simulation.removeScenarioByIndex(rowIndex);
        this.updateIndexColumn();
        return toReturn;
    }

    public void duplicateRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        int newRowIndex = rowIndex + 1;
        Scenario toDuplicate = this.simulation.cloneScenario(rowIndex, newRowIndex);
        this.insertRowGridOnly(newRowIndex, row, toDuplicate);
    }

    public void insertColumnGridOnly(int index, GridColumn<?> column) {
        this.checkSimulation();
        super.insertColumn(index, column);
    }

    public void insertColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(index, column);
    }

    public void deleteColumn(int columnIndex) {
        this.checkSimulation();
        GridColumn toDelete = (GridColumn)this.getColumns().get(columnIndex);
        this.deleteColumn(toDelete);
        this.simulation.removeFactMappingByIndex(columnIndex);
    }

    public void updateColumnInstance(int columnIndex, GridColumn<?> column) {
        this.checkSimulation();
        this.deleteColumn(columnIndex);
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, ei);
    }

    public void updateColumnProperty(int columnIndex, GridColumn<?> column, String value, String lastLevelClassName, boolean keepData) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, columnIndex).getValue()));
        }
        this.deleteColumn(columnIndex);
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        String[] elements = value.split("\\.");
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, ei);
        FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        IntStream.range(0, elements.length).forEach(stepIndex -> factMappingByIndex.addExpressionElement(elements[stepIndex], lastLevelClassName));
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, columnIndex, (GridCellValue)originalValues.get(rowIndex)));
        }
    }

    public GridData.Range setCellGridOnly(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        return super.setCell(rowIndex, columnIndex, cellSupplier);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = super.setCell(rowIndex, columnIndex, cellSupplier);
        try {
            Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
            Object rawValue = optionalValue.orElse(null);
            String cellValue = rawValue instanceof String ? (String)rawValue : null;
            Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        catch (Throwable t) {
            toReturn = super.deleteCell(rowIndex, columnIndex);
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
        }
        return toReturn;
    }

    public GridData.Range setCellValue(int rowIndex, int columnIndex, GridCellValue<?> value) {
        return this.setCell(rowIndex, columnIndex, () -> {
            ScenarioGridCell newCell = new ScenarioGridCell((ScenarioGridCellValue)value);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
            }
            return newCell;
        });
    }

    public GridData.Range deleteCell(int rowIndex, int columnIndex) {
        FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        this.simulation.getScenarioByIndex(rowIndex).removeFactMappingValueByIdentifiers(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
        return super.deleteCell(rowIndex, columnIndex);
    }

    public GridData.Range getInstanceLimits(int columnIndex) {
        int rightPosition;
        int leftPosition;
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)((Object)this.columns.get(columnIndex));
        String originalColumnGroup = selectedColumn.getInformationHeaderMetaData().getColumnGroup();
        ScenarioHeaderMetaData selectedInformationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        String originalColumnTitle = selectedInformationHeaderMetaData.getTitle();
        for (leftPosition = columnIndex; leftPosition > 1 && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); --leftPosition) {
        }
        for (rightPosition = columnIndex; rightPosition < this.columns.size() - 1 && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); ++rightPosition) {
        }
        return new GridData.Range(leftPosition, rightPosition);
    }

    public List<ScenarioGridColumn> getInstanceScenarioGridColumns(ScenarioGridColumn selectedColumn) {
        int columnIndex = this.columns.indexOf((Object)selectedColumn);
        GridData.Range instanceRange = this.getInstanceLimits(columnIndex);
        return this.columns.subList(instanceRange.getMinRowIndex(), instanceRange.getMaxRowIndex() + 1).stream().map(gridColumn -> (ScenarioGridColumn)((Object)gridColumn)).collect(Collectors.toList());
    }

    public int getFirstIndexLeftOfGroup(String groupName) {
        List columns = this.getColumns();
        Optional<Integer> first = columns.stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).findFirst().map(gridColumn -> {
            int indexOfColumn = columns.indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn : 0;
        });
        return first.orElseGet(() -> 0);
    }

    public int getFirstIndexRightOfGroup(String groupName) {
        Optional<Integer> last = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).reduce((first, second) -> second).map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn + 1 : this.getColumnCount();
        });
        return last.orElseGet(() -> ((ScenarioGridModel)this).getColumnCount());
    }

    public long getGroupSize(String groupName) {
        return this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).count();
    }

    public void updateHeader(int columnIndex, int headerRowIndex, String value) {
        ScenarioHeaderMetaData editedMetadata = (ScenarioHeaderMetaData)((Object)((GridColumn)this.getColumns().get(columnIndex)).getHeaderMetaData().get(headerRowIndex));
        if (Objects.equals(editedMetadata.getTitle(), value)) {
            return;
        }
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingToEdit = simulationDescriptor.getFactMappingByIndex(columnIndex);
        ScenarioHeaderMetaData.MetadataType metadataType = editedMetadata.getMetadataType();
        IntStream.range(0, this.getColumnCount()).forEach(index -> this.updateFactMapping(simulationDescriptor, factMappingToEdit, index, value, metadataType));
        if (editedMetadata.isInstanceHeader()) {
            this.eventBus.fireEvent((GwtEvent)new ReloadRightPanelEvent(false));
        }
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(x$0 -> super.deleteRow(x$0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(x$0 -> super.deleteColumn(x$0));
        if (this.simulation != null) {
            this.simulation.clear();
        }
    }

    public void clearSelections() {
        super.clearSelections();
        this.selectedColumn = null;
    }

    public void selectColumn(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
        if (!this.selectedHeaderCells.isEmpty()) {
            GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)this.selectedHeaderCells.get(0);
            this.selectedHeaderCells.clear();
            this.selectHeaderCell(selectedHeaderCell.getRowIndex(), columnIndex);
        }
        this.selectedColumn = (GridColumn)this.getColumns().get(columnIndex);
    }

    public void selectRow(int rowIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        int columns = this.getColumnCount();
        IntStream.range(0, columns).forEach(columnIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public GridColumn<?> getSelectedColumn() {
        return this.selectedColumn;
    }

    public Optional<Simulation> getSimulation() {
        return Optional.ofNullable(this.simulation);
    }

    public boolean isSelectedColumnEmpty() {
        return this.selectedColumn == null || this.isColumnEmpty(this.getColumns().indexOf(this.selectedColumn));
    }

    public boolean isColumnEmpty(int columnIndex) {
        return !IntStream.range(0, this.getRowCount()).filter(rowIndex -> this.getCellValue(this.getCell(rowIndex, columnIndex)).isPresent()).findFirst().isPresent();
    }

    public boolean isAlreadyAssignedProperty(String propertyName) {
        return this.selectedColumn == null || this.isAlreadyAssignedProperty(this.getColumns().indexOf(this.selectedColumn), propertyName);
    }

    public boolean isAlreadyAssignedProperty(int columnIndex, String propertyName) {
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        return IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(index -> index != columnIndex).mapToObj(arg_0 -> ((SimulationDescriptor)simulationDescriptor).getFactMappingByIndex(arg_0)).anyMatch(factMapping -> {
            String columnProperty = factMapping.getExpressionElements().stream().map(expressionElement -> expressionElement.getStep()).collect(Collectors.joining("."));
            return Objects.equals(columnProperty, propertyName);
        });
    }

    public boolean isSameSelectedColumnProperty(String propertyName) {
        return this.selectedColumn == null || this.isSameSelectedColumnProperty(this.getColumns().indexOf(this.selectedColumn), propertyName);
    }

    public boolean isSameSelectedColumnProperty(int columnIndex, String propertyName) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getExpressionAlias().equals(propertyName);
    }

    public boolean isSameSelectedColumnType(String className) {
        return this.selectedColumn == null || this.isSameSelectedColumnType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public boolean isSameSelectedColumnType(int columnIndex, String className) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getClassName().equals(className);
    }

    public boolean isSameInstanceHeader(int columnIndex, String headerName) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifierByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        String columnClassName = factIdentifierByIndex.getClassName();
        if (columnClassName.contains(".")) {
            columnClassName = columnClassName.substring(columnClassName.lastIndexOf(".") + 1);
        }
        return Objects.equals(columnClassName, headerName);
    }

    public boolean isSamePropertyHeader(int columnIndex, String headerName) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMapping = simulationDescriptor.getFactMappingByIndex(columnIndex);
        String columnPropertyName = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.joining("."));
        if (columnPropertyName.contains(".")) {
            columnPropertyName = columnPropertyName.substring(columnPropertyName.indexOf(".") + 1);
        }
        return Objects.equals(columnPropertyName, headerName);
    }

    public void resetErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::resetErrors);
    }

    public void resetErrors(int rowIndex) {
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
        scenarioByIndex.resetErrors();
        this.refreshErrors();
    }

    public void refreshErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::refreshErrorsRow);
    }

    public void setDataObjectsInstancesName(Set<String> dataObjectsInstancesName) {
        this.dataObjectsInstancesName = dataObjectsInstancesName;
    }

    public void setSimpleJavaTypeInstancesName(Set<String> simpleJavaTypeInstancesName) {
        this.simpleJavaTypeInstancesName = simpleJavaTypeInstancesName;
    }

    public boolean validateInstanceHeaderUpdate(String value, int columnIndex, boolean isADataType) {
        boolean isSameInstanceHeader = this.isSameInstanceHeader(columnIndex, value);
        return isADataType && isSameInstanceHeader && this.isUniqueInstanceHeaderTitle(value, columnIndex) || !isADataType && this.isUniqueInstanceHeaderTitle(value, columnIndex);
    }

    public boolean validatePropertyHeaderUpdate(String value, int columnIndex, boolean isPropertyType) {
        return isPropertyType && this.isSamePropertyHeader(columnIndex, value) && this.isUniquePropertyHeaderTitle(value, columnIndex) || !isPropertyType && !this.isAlreadyAssignedProperty(columnIndex, value) && this.isUniquePropertyHeaderTitle(value, columnIndex);
    }

    protected void updateFactMapping(SimulationDescriptor simulationDescriptor, FactMapping factMappingReference, int index, String value, ScenarioHeaderMetaData.MetadataType metadataType) {
        boolean toUpdate;
        FactIdentifier factIdentifierReference = factMappingReference.getFactIdentifier();
        FactMapping factMappingToCheck = simulationDescriptor.getFactMappingByIndex(index);
        FactIdentifier factIdentifierToCheck = factMappingToCheck.getFactIdentifier();
        boolean bl = toUpdate = Objects.equals(FactIdentifier.EMPTY, factIdentifierReference) && Objects.equals(factIdentifierToCheck, factIdentifierReference) && Objects.equals(factMappingReference.getFactAlias(), factMappingToCheck.getFactAlias()) || Objects.equals(factIdentifierToCheck, factIdentifierReference);
        if (toUpdate) {
            switch (metadataType) {
                case INSTANCE: {
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getInformationHeaderMetaData().setTitle(value);
                    factMappingToCheck.setFactAlias(value);
                    break;
                }
                case PROPERTY: {
                    if (!Objects.equals(factMappingToCheck.getFullExpression(), factMappingReference.getFullExpression())) break;
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getPropertyHeaderMetaData().setTitle(value);
                    factMappingToCheck.setExpressionAlias(value);
                    break;
                }
            }
        }
    }

    protected void commonAddColumn(int index, GridColumn<?> column) {
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(index, column, ei);
    }

    protected void commonAddColumn(int index, GridColumn<?> column, ExpressionIdentifier ei) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        String instanceTitle = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getTitle();
        String propertyTitle = ((ScenarioGridColumn)column).getPropertyHeaderMetaData().getTitle();
        int columnIndex = index == -1 ? this.getColumnCount() : index;
        try {
            FactMapping createdFactMapping = simulationDescriptor.addFactMapping(columnIndex, instanceTitle, ((ScenarioGridColumn)column).getFactIdentifier(), ei);
            createdFactMapping.setExpressionAlias(propertyTitle);
            if (index == -1) {
                super.appendColumn(column);
            } else {
                super.insertColumn(index, column);
            }
            GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
            IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(currentIndex -> currentIndex != columnIndex).forEach(currentIndex -> simulationDescriptor.getFactMappingByIndex(currentIndex).setFactAlias(createdFactMapping.getFactAlias()));
        }
        catch (Throwable t) {
            this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent("Error during column creation: " + t.getMessage(), NotificationEvent.NotificationType.ERROR));
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
            return;
        }
        List scenarios = this.simulation.getUnmodifiableScenarios();
        String placeHolder = ((ScenarioGridColumn)column).getPlaceHolder();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder))));
    }

    protected void commonAddRow(int rowIndex) {
        Scenario scenario = this.simulation.addScenario(rowIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        IntStream.range(1, this.getColumnCount()).forEach(columnIndex -> {
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            scenario.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), null);
            String placeHolder = ((ScenarioGridColumn)((Object)((Object)this.columns.get(columnIndex)))).isPropertyAssigned() ? ScenarioSimulationEditorConstants.INSTANCE.insertValue() : ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
            this.setCell(rowIndex, columnIndex, () -> {
                ScenarioGridCell newCell = new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder));
                if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                    newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
                }
                return newCell;
            });
        });
        this.updateIndexColumn();
    }

    protected void updateIndexColumn() {
        Optional<GridColumn> indexColumn = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle().equals(FactIdentifier.INDEX.getName())).findFirst();
        indexColumn.ifPresent(column -> {
            int indexOfColumn = this.getColumns().indexOf(column);
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> {
                String value = String.valueOf(rowIndex + 1);
                this.setCellValue(rowIndex, indexOfColumn, (GridCellValue<?>)new ScenarioGridCellValue(value));
            });
        });
    }

    protected void checkSimulation() {
        Objects.requireNonNull(this.simulation, "Bind a simulation to the ScenarioGridModel to use it");
    }

    protected boolean isUniqueInstanceHeaderTitle(String value, int columnIndex) {
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        return IntStream.range(0, this.getColumnCount()).filter(index -> index < instanceLimits.getMinRowIndex() || index > instanceLimits.getMaxRowIndex()).filter(index -> !Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getInformationHeaderMetaData() != null).map(ScenarioGridColumn::getInformationHeaderMetaData).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected boolean isUniquePropertyHeaderTitle(String value, int columnIndex) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        return IntStream.range(0, this.getColumnCount()).filter(index -> index != columnIndex).filter(index -> Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getPropertyHeaderMetaData() != null).map(ScenarioGridColumn::getPropertyHeaderMetaData).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected boolean isNewInstanceName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getInformationHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected boolean isNewPropertyName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getPropertyHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected void refreshErrorsRow(int rowIndex) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
        IntStream.range(0, this.getColumnCount()).forEach(columnIndex -> {
            ScenarioGridCell cell = (ScenarioGridCell)this.getCell(rowIndex, columnIndex);
            if (cell == null) {
                return;
            }
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            Optional factMappingValue = scenarioByIndex.getFactMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier());
            if (factMappingValue.isPresent()) {
                cell.setErrorMode(((FactMappingValue)factMappingValue.get()).isError());
            } else {
                cell.setErrorMode(false);
            }
        });
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        if (gridCell == null || gridCell.getValue() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(gridCell.getValue().getValue());
    }
}

