/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;

public class PropertyPresenter
implements PropertyView.Presenter {
    @Inject
    protected ViewsProvider viewsProvider;
    protected Map<String, SpanElement> propertySpanElementMap = new HashMap<String, SpanElement>();
    protected Map<String, List<PropertyView>> propertyViewMap = new HashMap<String, List<PropertyView>>();

    @Override
    public String getPropertyValue(String propertyName) throws Exception {
        if (this.propertySpanElementMap.containsKey(propertyName)) {
            return this.propertySpanElementMap.get(propertyName).getInnerText();
        }
        throw new Exception(propertyName + " not found");
    }

    @Override
    public void editProperties(String itemId) {
        this.propertyViewMap.get(itemId).forEach(propertyEditorView -> {
            propertyEditorView.getPropertyValueSpan().getStyle().setDisplay(Style.Display.NONE);
            propertyEditorView.getPropertyValueInput().setValue(propertyEditorView.getPropertyValueSpan().getInnerText());
            propertyEditorView.getPropertyValueInput().getStyle().setDisplay(Style.Display.INLINE);
            propertyEditorView.getPropertyValueInput().setDisabled(false);
        });
    }

    @Override
    public void stopEditProperties(String itemId) {
        this.stopEdit(itemId, false);
    }

    @Override
    public Map<String, String> updateProperties(String itemId) {
        return this.stopEdit(itemId, true);
    }

    @Override
    public Map<String, String> getProperties(String itemId) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        this.propertyViewMap.get(itemId).forEach(propertyEditorView -> {
            String propertyName = propertyEditorView.getPropertyName().getInnerText();
            propertyName = propertyName.substring(propertyName.lastIndexOf("#") + 1);
            toReturn.put(propertyName, propertyEditorView.getPropertyValueSpan().getInnerText());
        });
        return toReturn;
    }

    @Override
    public LIElement getPropertyFields(String itemId, String propertyName, String propertyValue) {
        PropertyView propertyEditorView = this.viewsProvider.getPropertyEditorView();
        String hashedPropertyName = "#" + propertyName;
        SpanElement propertyNameSpan = propertyEditorView.getPropertyName();
        CollectionEditorUtils.setSpanAttributeAttributes(propertyName, hashedPropertyName, "propertyName" + hashedPropertyName, propertyNameSpan);
        SpanElement propertyValueSpan = propertyEditorView.getPropertyValueSpan();
        CollectionEditorUtils.setSpanAttributeAttributes(propertyName, propertyValue, "propertyValue" + hashedPropertyName, propertyValueSpan);
        this.propertySpanElementMap.put(propertyName, propertyValueSpan);
        InputElement propertyValueInput = propertyEditorView.getPropertyValueInput();
        propertyValueInput.setAttribute("placeholder", hashedPropertyName);
        propertyValueInput.setAttribute("data-field", "propertyValue" + hashedPropertyName);
        propertyValueInput.setDisabled(true);
        propertyValueInput.getStyle().setDisplay(Style.Display.NONE);
        LIElement propertyFields = propertyEditorView.getPropertyFields();
        propertyFields.setAttribute("data-field", "propertyFields" + hashedPropertyName);
        if (this.propertyViewMap.containsKey(itemId)) {
            this.propertyViewMap.get(itemId).add(propertyEditorView);
        } else {
            ArrayList<PropertyView> toPut = new ArrayList<PropertyView>();
            toPut.add(propertyEditorView);
            this.propertyViewMap.put(itemId, toPut);
        }
        return propertyFields;
    }

    @Override
    public LIElement getEditingPropertyFields(String itemId, String propertyName, String propertyValue) {
        LIElement toReturn = this.getPropertyFields(itemId, propertyName, propertyValue);
        this.editProperties(itemId);
        return toReturn;
    }

    @Override
    public void onToggleRowExpansion(String itemId, boolean isShown) {
        this.propertyViewMap.get(itemId).forEach(propertyEditorView -> CollectionEditorUtils.toggleRowExpansion(propertyEditorView.getPropertyFields(), isShown));
    }

    @Override
    public void deleteProperties(String itemId) {
        this.propertyViewMap.get(itemId).forEach(propertyEditorView -> {
            String propertyName = propertyEditorView.getPropertyName().getAttribute("data-i18n-key");
            propertyEditorView.getPropertyFields().removeFromParent();
            this.propertySpanElementMap.remove(propertyName);
        });
        this.propertyViewMap.remove(itemId);
    }

    protected Map<String, String> stopEdit(String itemId, boolean toUpdate) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        this.propertyViewMap.get(itemId).forEach(propertyEditorView -> {
            if (toUpdate) {
                propertyEditorView.getPropertyValueSpan().setInnerText(propertyEditorView.getPropertyValueInput().getValue());
            }
            propertyEditorView.getPropertyValueSpan().getStyle().setDisplay(Style.Display.INLINE);
            propertyEditorView.getPropertyValueInput().getStyle().setDisplay(Style.Display.NONE);
            propertyEditorView.getPropertyValueInput().setDisabled(true);
            String propertyName = propertyEditorView.getPropertyName().getInnerText();
            propertyName = propertyName.substring(propertyName.lastIndexOf("#") + 1);
            toReturn.put(propertyName, propertyEditorView.getPropertyValueSpan().getInnerText());
        });
        return toReturn;
    }
}

