/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

@Dependent
public class SetHeaderCellValueCommand
extends AbstractScenarioSimulationCommand {
    protected boolean isInstanceHeader;
    protected boolean isPropertyHeader;

    public SetHeaderCellValueCommand() {
        this(false, false);
    }

    public SetHeaderCellValueCommand(boolean isInstanceHeader, boolean isPropertyHeader) {
        super(true);
        this.isInstanceHeader = isInstanceHeader;
        this.isPropertyHeader = isPropertyHeader;
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) throws Exception {
        ScenarioSimulationContext.Status status = context.getStatus();
        String headerValue = status.getCellValue();
        boolean valid = false;
        if (this.isInstanceHeader) {
            valid = this.validateInstanceHeader(context, headerValue, status.getColumnIndex());
        } else if (this.isPropertyHeader) {
            valid = this.validatePropertyHeader(context, headerValue, status.getColumnIndex());
        }
        if (!valid) {
            throw new Exception("Name \"" + headerValue + "\" cannot be used");
        }
        context.getModel().updateHeader(status.getColumnIndex(), status.getRowIndex(), headerValue);
    }

    protected boolean validateInstanceHeader(ScenarioSimulationContext context, String headerValue, int columnIndex) {
        boolean isADataType = context.getDataObjectFieldsMap().containsKey(headerValue);
        return context.getModel().validateInstanceHeaderUpdate(headerValue, columnIndex, isADataType);
    }

    protected boolean validatePropertyHeader(ScenarioSimulationContext context, String headerValue, int columnIndex) {
        FactModelTree factModelTree;
        FactMapping factMappingByIndex = context.getStatus().getSimulation().getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        String className = factMappingByIndex.getFactIdentifier().getClassName();
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        boolean isPropertyType = (factModelTree = (FactModelTree)context.getDataObjectFieldsMap().get(className)) != null && (factModelTree.getSimpleProperties().containsKey(headerValue) || factModelTree.getExpandableProperties().containsKey(headerValue));
        return context.getModel().validatePropertyHeaderUpdate(headerValue, columnIndex, isPropertyType);
    }
}

