/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Div;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.examples.client.wizard.widgets.ComboBox;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.util.URIUtil;

public class TitledAttachmentFileWidget
extends Composite
implements ValueChangeHandler<String> {
    protected VerticalPanel fields = (VerticalPanel)GWT.create(VerticalPanel.class);
    protected Div divElement = (Div)GWT.create(Div.class);
    protected FormLabel titleLabel = (FormLabel)GWT.create(FormLabel.class);
    protected Span errorLabel = (Span)GWT.create(Span.class);
    protected ComboBox comboBox = (ComboBox)GWT.create(ComboBox.class);
    protected LibraryPlaces libraryPlaces;
    protected AssetQueryService assetQueryService;
    protected WorkspaceProject workspaceProject;
    protected String selectedPath;

    public TitledAttachmentFileWidget(String title, LibraryPlaces libraryPlaces, AssetQueryService assetQueryService) {
        this.titleLabel.setStyleName("control-label");
        this.titleLabel.setText(title);
        this.divElement.add((Widget)this.titleLabel);
        this.divElement.getElement().appendChild((Node)this.createIconElement());
        this.errorLabel.setStyleName("help-block");
        this.errorLabel.setColor("#c00");
        this.errorLabel.setText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        this.fields.add((Widget)this.divElement);
        this.fields.add((Widget)this.comboBox);
        this.fields.add((Widget)this.errorLabel);
        this.libraryPlaces = libraryPlaces;
        this.assetQueryService = assetQueryService;
        this.workspaceProject = libraryPlaces.getActiveWorkspace();
        this.initWidget((Widget)this.fields);
        this.comboBox.addValueChangeHandler((ValueChangeHandler)this);
    }

    public void clearStatus() {
        this.updateAssetList();
        this.comboBox.setText(null);
        this.errorLabel.setText(null);
        this.selectedPath = null;
    }

    public void updateAssetList() {
        this.comboBox.clear();
        this.updateAssets((RemoteCallback<AssetQueryResult>)((RemoteCallback)this::addAssets));
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean validate() {
        boolean toReturn;
        boolean bl = toReturn = this.selectedPath != null && !this.selectedPath.isEmpty();
        if (!toReturn) {
            this.errorLabel.setText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        } else {
            this.errorLabel.setText(null);
        }
        return toReturn;
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.selectedPath = (String)event.getValue();
        this.validate();
    }

    protected void updateAssets(RemoteCallback<AssetQueryResult> callback) {
        ProjectAssetsQuery query = this.createProjectQuery();
        this.assetQueryService.getAssets(query).call(callback, (ErrorCallback)new DefaultErrorCallback());
    }

    protected ProjectAssetsQuery createProjectQuery() {
        List<String> suffixes = Collections.singletonList("dmn");
        return new ProjectAssetsQuery(this.workspaceProject, "", 0, 1000, suffixes);
    }

    protected void addAssets(AssetQueryResult result) {
        if (Objects.equals(AssetQueryResult.ResultType.Normal, result.getResultType())) {
            List assetInfos = (List)result.getAssetInfos().get();
            assetInfos.forEach(asset -> {
                if (asset.getFolderItem().getType().equals((Object)FolderItemType.FILE)) {
                    this.comboBox.addItem(this.getAssetPath((AssetInfo)asset));
                }
            });
        }
    }

    protected String getAssetPath(AssetInfo asset) {
        String fullPath = ((Path)asset.getFolderItem().getItem()).toURI();
        String projectRootPath = this.workspaceProject.getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length());
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        return decodedRelativeAssetPath;
    }

    protected Element createIconElement() {
        Element e = Document.get().createElement("i");
        e.addClassName("fa");
        e.addClassName(IconType.STAR.getCssName());
        Style s = e.getStyle();
        s.setFontSize(6.0, Style.Unit.PX);
        s.setPaddingLeft(2.0, Style.Unit.PX);
        s.setPaddingRight(5.0, Style.Unit.PX);
        s.setColor("#b94a48");
        Element sup = Document.get().createElement("sup");
        sup.appendChild((Node)e);
        return sup;
    }
}

