/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.menu;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventBus;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@Dependent
public class ScenarioContextMenuRegistry {
    protected OtherContextMenu otherContextMenu;
    protected HeaderGivenContextMenu headerGivenContextMenu;
    protected HeaderExpectedContextMenu headerExpectedContextMenu;
    protected GivenContextMenu givenContextMenu;
    protected ExpectedContextMenu expectedContextMenu;
    protected GridContextMenu gridContextMenu;
    protected UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu;
    protected ErrorReportPopoverPresenter errorReportPopoverPresenter;

    @Inject
    public ScenarioContextMenuRegistry(OtherContextMenu otherContextMenu, HeaderGivenContextMenu headerGivenContextMenu, HeaderExpectedContextMenu headerExpectedContextMenu, GivenContextMenu givenContextMenu, ExpectedContextMenu expectedContextMenu, GridContextMenu gridContextMenu, UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu) {
        this.otherContextMenu = otherContextMenu;
        this.headerGivenContextMenu = headerGivenContextMenu;
        this.headerExpectedContextMenu = headerExpectedContextMenu;
        this.givenContextMenu = givenContextMenu;
        this.expectedContextMenu = expectedContextMenu;
        this.gridContextMenu = gridContextMenu;
        this.unmodifiableColumnGridContextMenu = unmodifiableColumnGridContextMenu;
    }

    public void setEventBus(EventBus eventBus) {
        this.otherContextMenu.setEventBus(eventBus);
        this.headerGivenContextMenu.setEventBus(eventBus);
        this.headerExpectedContextMenu.setEventBus(eventBus);
        this.givenContextMenu.setEventBus(eventBus);
        this.expectedContextMenu.setEventBus(eventBus);
        this.gridContextMenu.setEventBus(eventBus);
        this.unmodifiableColumnGridContextMenu.setEventBus(eventBus);
    }

    public void hideMenus() {
        this.otherContextMenu.hide();
        this.headerGivenContextMenu.hide();
        this.headerExpectedContextMenu.hide();
        this.givenContextMenu.hide();
        this.expectedContextMenu.hide();
        this.gridContextMenu.hide();
        this.unmodifiableColumnGridContextMenu.hide();
    }

    public boolean manageRightClick(ScenarioGrid scenarioGrid, ContextMenuEvent event) {
        int canvasX = CoordinateUtilities.getRelativeXOfEvent((DomEvent)event);
        int canvasY = CoordinateUtilities.getRelativeYOfEvent((DomEvent)event);
        Point2D gridClickPoint = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        boolean isHeader = true;
        Integer uiRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)scenarioGrid, (Point2D)gridClickPoint);
        if (uiRowIndex == null) {
            uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)scenarioGrid, (double)gridClickPoint.getY());
            isHeader = false;
        }
        if (uiRowIndex == null) {
            return false;
        }
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)scenarioGrid, (double)gridClickPoint.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        return this.manageRightClick(scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), uiRowIndex, uiColumnIndex, isHeader);
    }

    public boolean manageRightClick(ScenarioGrid scenarioGrid, int clientXPosition, int clientYPosition, Integer uiRowIndex, Integer uiColumnIndex, boolean isHeader) {
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        if (isHeader) {
            return this.manageHeaderRightClick(scenarioGrid, clientXPosition, clientYPosition, uiRowIndex, uiColumnIndex);
        }
        return this.manageBodyRightClickLocal(scenarioGrid, clientXPosition, clientYPosition, uiRowIndex, uiColumnIndex);
    }

    private boolean manageBodyRightClickLocal(ScenarioGrid scenarioGrid, int left, int top, Integer uiRowIndex, Integer uiColumnIndex) {
        if (uiRowIndex == null) {
            return false;
        }
        return this.manageScenarioBodyRightClick(scenarioGrid, left, top, uiRowIndex, uiColumnIndex);
    }

    private boolean manageScenarioBodyRightClick(ScenarioGrid scenarioGrid, int left, int top, int uiRowIndex, int uiColumnIndex) {
        String group;
        scenarioGrid.deselect();
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        switch (group = scenarioGridColumn.getInformationHeaderMetaData().getColumnGroup()) {
            case "GIVEN": 
            case "EXPECT": {
                this.gridContextMenu.show(left, top, uiRowIndex);
                break;
            }
            default: {
                this.unmodifiableColumnGridContextMenu.show(left, top, uiRowIndex);
            }
        }
        return true;
    }

    private boolean manageHeaderRightClick(ScenarioGrid scenarioGrid, int left, int top, Integer uiHeaderRowIndex, Integer uiColumnIndex) {
        ScenarioGridColumn column = (ScenarioGridColumn)((Object)scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (column == null) {
            return false;
        }
        ScenarioHeaderMetaData columnMetadata = ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData(column, uiHeaderRowIndex);
        if (columnMetadata == null) {
            return false;
        }
        if (uiHeaderRowIndex == null) {
            return false;
        }
        boolean showDuplicateInstance = scenarioGrid.getModel().getSimulation().get().getSimulationDescriptor().getType().equals((Object)ScenarioSimulationModel.Type.RULE);
        String group = columnMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        block5 : switch (group) {
            case "": {
                switch (columnMetadata.getTitle()) {
                    case "GIVEN": {
                        this.headerGivenContextMenu.show(left, top);
                        break block5;
                    }
                    case "EXPECT": {
                        this.headerExpectedContextMenu.show(left, top);
                        break block5;
                    }
                }
                this.otherContextMenu.show(left, top);
                break;
            }
            case "GIVEN": {
                this.givenContextMenu.show(left, top, uiColumnIndex, group, Objects.equals((Object)columnMetadata.getMetadataType(), (Object)ScenarioHeaderMetaData.MetadataType.PROPERTY), showDuplicateInstance);
                break;
            }
            case "EXPECT": {
                this.expectedContextMenu.show(left, top, uiColumnIndex, group, Objects.equals((Object)columnMetadata.getMetadataType(), (Object)ScenarioHeaderMetaData.MetadataType.PROPERTY), showDuplicateInstance);
                break;
            }
            default: {
                this.otherContextMenu.show(left, top);
            }
        }
        scenarioGrid.setSelectedColumnAndHeader(uiHeaderRowIndex, uiColumnIndex);
        return true;
    }

    public void setErrorReportPopoverPresenter(ErrorReportPopoverPresenter errorReportPopoverPresenter) {
        this.errorReportPopoverPresenter = errorReportPopoverPresenter;
    }

    public void hideErrorReportPopover() {
        this.errorReportPopoverPresenter.hide();
    }
}

