/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationInvokeContextMenuForSelectedCell;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class ScenarioInvokeContextMenuForSelectedCell
extends KeyboardOperationInvokeContextMenuForSelectedCell {
    private ScenarioContextMenuRegistry scenarioContextMenuRegistry;

    public ScenarioInvokeContextMenuForSelectedCell(GridLayer gridLayer, ScenarioContextMenuRegistry scenarioContextMenuRegistry) {
        super(gridLayer);
        this.scenarioContextMenuRegistry = scenarioContextMenuRegistry;
    }

    public boolean isExecutable(GridWidget gridWidget) {
        GridData model = gridWidget.getModel();
        if (model.getSelectedHeaderCells().size() == 1 && model.getSelectedCells().size() == 0) {
            return true;
        }
        return model.getSelectedHeaderCells().size() == 0 && model.getSelectedCells().size() == 1;
    }

    public boolean perform(GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData model = gridWidget.getModel();
        GridData.SelectedCell origin = null;
        boolean isHeader = false;
        if (model.getSelectedHeaderCells().size() == 1) {
            origin = (GridData.SelectedCell)model.getSelectedHeaderCells().get(0);
            isHeader = true;
        } else if (model.getSelectedCells().size() == 1) {
            origin = model.getSelectedCellsOrigin();
            isHeader = false;
        }
        int uiRowIndex = origin.getRowIndex();
        int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex((List)model.getColumns(), (int)origin.getColumnIndex());
        GridColumn column = (GridColumn)model.getColumns().get(uiColumnIndex);
        if (column instanceof ScenarioGridColumn) {
            Point2D middleXYCell = ScenarioSimulationUtils.getMiddleXYCell(gridWidget, column, isHeader, uiRowIndex, this.gridLayer);
            return this.scenarioContextMenuRegistry.manageRightClick((ScenarioGrid)gridWidget, (int)middleXYCell.getX(), (int)middleXYCell.getY(), uiRowIndex, uiColumnIndex, isHeader);
        }
        return false;
    }
}

